package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{JobDescription, JobId, JobArn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AssociateTargetsWithJobResponse(
    jobArn: Optional[JobArn] = Optional.Absent,
    jobId: Optional[JobId] = Optional.Absent,
    description: Optional[JobDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AssociateTargetsWithJobResponse = {
    import AssociateTargetsWithJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AssociateTargetsWithJobResponse
      .builder()
      .optionallyWith(
        jobArn.map(value => JobArn.unwrap(value): java.lang.String)
      )(_.jobArn)
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(
        description.map(value => JobDescription.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AssociateTargetsWithJobResponse.ReadOnly =
    zio.aws.iot.model.AssociateTargetsWithJobResponse.wrap(buildAwsValue())
}
object AssociateTargetsWithJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AssociateTargetsWithJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AssociateTargetsWithJobResponse =
      zio.aws.iot.model.AssociateTargetsWithJobResponse(
        jobArn.map(value => value),
        jobId.map(value => value),
        description.map(value => value)
      )
    def jobArn: Optional[JobArn]
    def jobId: Optional[JobId]
    def description: Optional[JobDescription]
    def getJobArn: ZIO[Any, AwsError, JobArn] =
      AwsError.unwrapOptionField("jobArn", jobArn)
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getDescription: ZIO[Any, AwsError, JobDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AssociateTargetsWithJobResponse
  ) extends zio.aws.iot.model.AssociateTargetsWithJobResponse.ReadOnly {
    override val jobArn: Optional[JobArn] = zio.aws.core.internal
      .optionalFromNullable(impl.jobArn())
      .map(value => zio.aws.iot.model.primitives.JobArn(value))
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.iot.model.primitives.JobId(value))
    override val description: Optional[JobDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iot.model.primitives.JobDescription(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AssociateTargetsWithJobResponse
  ): zio.aws.iot.model.AssociateTargetsWithJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
