package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{Principal, ThingName}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AttachThingPrincipalRequest(
    thingName: ThingName,
    principal: Principal
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AttachThingPrincipalRequest = {
    import AttachThingPrincipalRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AttachThingPrincipalRequest
      .builder()
      .thingName(ThingName.unwrap(thingName): java.lang.String)
      .principal(Principal.unwrap(principal): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AttachThingPrincipalRequest.ReadOnly =
    zio.aws.iot.model.AttachThingPrincipalRequest.wrap(buildAwsValue())
}
object AttachThingPrincipalRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AttachThingPrincipalRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AttachThingPrincipalRequest =
      zio.aws.iot.model.AttachThingPrincipalRequest(thingName, principal)
    def thingName: ThingName
    def principal: Principal
    def getThingName: ZIO[Any, Nothing, ThingName] = ZIO.succeed(thingName)
    def getPrincipal: ZIO[Any, Nothing, Principal] = ZIO.succeed(principal)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AttachThingPrincipalRequest
  ) extends zio.aws.iot.model.AttachThingPrincipalRequest.ReadOnly {
    override val thingName: ThingName =
      zio.aws.iot.model.primitives.ThingName(impl.thingName())
    override val principal: Principal =
      zio.aws.iot.model.primitives.Principal(impl.principal())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AttachThingPrincipalRequest
  ): zio.aws.iot.model.AttachThingPrincipalRequest.ReadOnly = new Wrapper(impl)
}
