package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.Enabled
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AuditCheckConfiguration(
    enabled: Optional[Enabled] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AuditCheckConfiguration = {
    import AuditCheckConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AuditCheckConfiguration
      .builder()
      .optionallyWith(
        enabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AuditCheckConfiguration.ReadOnly =
    zio.aws.iot.model.AuditCheckConfiguration.wrap(buildAwsValue())
}
object AuditCheckConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AuditCheckConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AuditCheckConfiguration =
      zio.aws.iot.model.AuditCheckConfiguration(enabled.map(value => value))
    def enabled: Optional[Enabled]
    def getEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AuditCheckConfiguration
  ) extends zio.aws.iot.model.AuditCheckConfiguration.ReadOnly {
    override val enabled: Optional[Enabled] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => zio.aws.iot.model.primitives.Enabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AuditCheckConfiguration
  ): zio.aws.iot.model.AuditCheckConfiguration.ReadOnly = new Wrapper(impl)
}
