package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ErrorMessage,
  TotalResourcesCount,
  NonCompliantResourcesCount,
  ErrorCode,
  SuppressedNonCompliantResourcesCount,
  CheckCompliant
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AuditCheckDetails(
    checkRunStatus: Optional[zio.aws.iot.model.AuditCheckRunStatus] =
      Optional.Absent,
    checkCompliant: Optional[CheckCompliant] = Optional.Absent,
    totalResourcesCount: Optional[TotalResourcesCount] = Optional.Absent,
    nonCompliantResourcesCount: Optional[NonCompliantResourcesCount] =
      Optional.Absent,
    suppressedNonCompliantResourcesCount: Optional[
      SuppressedNonCompliantResourcesCount
    ] = Optional.Absent,
    errorCode: Optional[ErrorCode] = Optional.Absent,
    message: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AuditCheckDetails = {
    import AuditCheckDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AuditCheckDetails
      .builder()
      .optionallyWith(checkRunStatus.map(value => value.unwrap))(
        _.checkRunStatus
      )
      .optionallyWith(
        checkCompliant.map(value =>
          CheckCompliant.unwrap(value): java.lang.Boolean
        )
      )(_.checkCompliant)
      .optionallyWith(
        totalResourcesCount.map(value =>
          TotalResourcesCount.unwrap(value): java.lang.Long
        )
      )(_.totalResourcesCount)
      .optionallyWith(
        nonCompliantResourcesCount.map(value =>
          NonCompliantResourcesCount.unwrap(value): java.lang.Long
        )
      )(_.nonCompliantResourcesCount)
      .optionallyWith(
        suppressedNonCompliantResourcesCount.map(value =>
          SuppressedNonCompliantResourcesCount.unwrap(value): java.lang.Long
        )
      )(_.suppressedNonCompliantResourcesCount)
      .optionallyWith(
        errorCode.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        message.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AuditCheckDetails.ReadOnly =
    zio.aws.iot.model.AuditCheckDetails.wrap(buildAwsValue())
}
object AuditCheckDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AuditCheckDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AuditCheckDetails =
      zio.aws.iot.model.AuditCheckDetails(
        checkRunStatus.map(value => value),
        checkCompliant.map(value => value),
        totalResourcesCount.map(value => value),
        nonCompliantResourcesCount.map(value => value),
        suppressedNonCompliantResourcesCount.map(value => value),
        errorCode.map(value => value),
        message.map(value => value)
      )
    def checkRunStatus: Optional[zio.aws.iot.model.AuditCheckRunStatus]
    def checkCompliant: Optional[CheckCompliant]
    def totalResourcesCount: Optional[TotalResourcesCount]
    def nonCompliantResourcesCount: Optional[NonCompliantResourcesCount]
    def suppressedNonCompliantResourcesCount
        : Optional[SuppressedNonCompliantResourcesCount]
    def errorCode: Optional[ErrorCode]
    def message: Optional[ErrorMessage]
    def getCheckRunStatus
        : ZIO[Any, AwsError, zio.aws.iot.model.AuditCheckRunStatus] =
      AwsError.unwrapOptionField("checkRunStatus", checkRunStatus)
    def getCheckCompliant: ZIO[Any, AwsError, CheckCompliant] =
      AwsError.unwrapOptionField("checkCompliant", checkCompliant)
    def getTotalResourcesCount: ZIO[Any, AwsError, TotalResourcesCount] =
      AwsError.unwrapOptionField("totalResourcesCount", totalResourcesCount)
    def getNonCompliantResourcesCount
        : ZIO[Any, AwsError, NonCompliantResourcesCount] =
      AwsError.unwrapOptionField(
        "nonCompliantResourcesCount",
        nonCompliantResourcesCount
      )
    def getSuppressedNonCompliantResourcesCount
        : ZIO[Any, AwsError, SuppressedNonCompliantResourcesCount] =
      AwsError.unwrapOptionField(
        "suppressedNonCompliantResourcesCount",
        suppressedNonCompliantResourcesCount
      )
    def getErrorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AuditCheckDetails
  ) extends zio.aws.iot.model.AuditCheckDetails.ReadOnly {
    override val checkRunStatus
        : Optional[zio.aws.iot.model.AuditCheckRunStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.checkRunStatus())
        .map(value => zio.aws.iot.model.AuditCheckRunStatus.wrap(value))
    override val checkCompliant: Optional[CheckCompliant] =
      zio.aws.core.internal
        .optionalFromNullable(impl.checkCompliant())
        .map(value => zio.aws.iot.model.primitives.CheckCompliant(value))
    override val totalResourcesCount: Optional[TotalResourcesCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalResourcesCount())
        .map(value => zio.aws.iot.model.primitives.TotalResourcesCount(value))
    override val nonCompliantResourcesCount
        : Optional[NonCompliantResourcesCount] = zio.aws.core.internal
      .optionalFromNullable(impl.nonCompliantResourcesCount())
      .map(value =>
        zio.aws.iot.model.primitives.NonCompliantResourcesCount(value)
      )
    override val suppressedNonCompliantResourcesCount
        : Optional[SuppressedNonCompliantResourcesCount] = zio.aws.core.internal
      .optionalFromNullable(impl.suppressedNonCompliantResourcesCount())
      .map(value =>
        zio.aws.iot.model.primitives.SuppressedNonCompliantResourcesCount(value)
      )
    override val errorCode: Optional[ErrorCode] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => zio.aws.iot.model.primitives.ErrorCode(value))
    override val message: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.iot.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AuditCheckDetails
  ): zio.aws.iot.model.AuditCheckDetails.ReadOnly = new Wrapper(impl)
}
