package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  KeyValue,
  BooleanKey,
  EnableCachingForHttp,
  DateType,
  KeyName,
  AuthorizerName,
  AuthorizerFunctionArn,
  AuthorizerArn,
  TokenKeyName
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class AuthorizerDescription(
    authorizerName: Optional[AuthorizerName] = Optional.Absent,
    authorizerArn: Optional[AuthorizerArn] = Optional.Absent,
    authorizerFunctionArn: Optional[AuthorizerFunctionArn] = Optional.Absent,
    tokenKeyName: Optional[TokenKeyName] = Optional.Absent,
    tokenSigningPublicKeys: Optional[Map[KeyName, KeyValue]] = Optional.Absent,
    status: Optional[zio.aws.iot.model.AuthorizerStatus] = Optional.Absent,
    creationDate: Optional[DateType] = Optional.Absent,
    lastModifiedDate: Optional[DateType] = Optional.Absent,
    signingDisabled: Optional[BooleanKey] = Optional.Absent,
    enableCachingForHttp: Optional[EnableCachingForHttp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AuthorizerDescription = {
    import AuthorizerDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AuthorizerDescription
      .builder()
      .optionallyWith(
        authorizerName.map(value =>
          AuthorizerName.unwrap(value): java.lang.String
        )
      )(_.authorizerName)
      .optionallyWith(
        authorizerArn.map(value =>
          AuthorizerArn.unwrap(value): java.lang.String
        )
      )(_.authorizerArn)
      .optionallyWith(
        authorizerFunctionArn.map(value =>
          AuthorizerFunctionArn.unwrap(value): java.lang.String
        )
      )(_.authorizerFunctionArn)
      .optionallyWith(
        tokenKeyName.map(value => TokenKeyName.unwrap(value): java.lang.String)
      )(_.tokenKeyName)
      .optionallyWith(
        tokenSigningPublicKeys.map(value =>
          value
            .map({ case (key, value) =>
              (KeyName.unwrap(key): java.lang.String) -> (KeyValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tokenSigningPublicKeys)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        signingDisabled.map(value =>
          BooleanKey.unwrap(value): java.lang.Boolean
        )
      )(_.signingDisabled)
      .optionallyWith(
        enableCachingForHttp.map(value =>
          EnableCachingForHttp.unwrap(value): java.lang.Boolean
        )
      )(_.enableCachingForHttp)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AuthorizerDescription.ReadOnly =
    zio.aws.iot.model.AuthorizerDescription.wrap(buildAwsValue())
}
object AuthorizerDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AuthorizerDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AuthorizerDescription =
      zio.aws.iot.model.AuthorizerDescription(
        authorizerName.map(value => value),
        authorizerArn.map(value => value),
        authorizerFunctionArn.map(value => value),
        tokenKeyName.map(value => value),
        tokenSigningPublicKeys.map(value => value),
        status.map(value => value),
        creationDate.map(value => value),
        lastModifiedDate.map(value => value),
        signingDisabled.map(value => value),
        enableCachingForHttp.map(value => value)
      )
    def authorizerName: Optional[AuthorizerName]
    def authorizerArn: Optional[AuthorizerArn]
    def authorizerFunctionArn: Optional[AuthorizerFunctionArn]
    def tokenKeyName: Optional[TokenKeyName]
    def tokenSigningPublicKeys: Optional[Map[KeyName, KeyValue]]
    def status: Optional[zio.aws.iot.model.AuthorizerStatus]
    def creationDate: Optional[DateType]
    def lastModifiedDate: Optional[DateType]
    def signingDisabled: Optional[BooleanKey]
    def enableCachingForHttp: Optional[EnableCachingForHttp]
    def getAuthorizerName: ZIO[Any, AwsError, AuthorizerName] =
      AwsError.unwrapOptionField("authorizerName", authorizerName)
    def getAuthorizerArn: ZIO[Any, AwsError, AuthorizerArn] =
      AwsError.unwrapOptionField("authorizerArn", authorizerArn)
    def getAuthorizerFunctionArn: ZIO[Any, AwsError, AuthorizerFunctionArn] =
      AwsError.unwrapOptionField("authorizerFunctionArn", authorizerFunctionArn)
    def getTokenKeyName: ZIO[Any, AwsError, TokenKeyName] =
      AwsError.unwrapOptionField("tokenKeyName", tokenKeyName)
    def getTokenSigningPublicKeys: ZIO[Any, AwsError, Map[KeyName, KeyValue]] =
      AwsError.unwrapOptionField(
        "tokenSigningPublicKeys",
        tokenSigningPublicKeys
      )
    def getStatus: ZIO[Any, AwsError, zio.aws.iot.model.AuthorizerStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getSigningDisabled: ZIO[Any, AwsError, BooleanKey] =
      AwsError.unwrapOptionField("signingDisabled", signingDisabled)
    def getEnableCachingForHttp: ZIO[Any, AwsError, EnableCachingForHttp] =
      AwsError.unwrapOptionField("enableCachingForHttp", enableCachingForHttp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AuthorizerDescription
  ) extends zio.aws.iot.model.AuthorizerDescription.ReadOnly {
    override val authorizerName: Optional[AuthorizerName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authorizerName())
        .map(value => zio.aws.iot.model.primitives.AuthorizerName(value))
    override val authorizerArn: Optional[AuthorizerArn] = zio.aws.core.internal
      .optionalFromNullable(impl.authorizerArn())
      .map(value => zio.aws.iot.model.primitives.AuthorizerArn(value))
    override val authorizerFunctionArn: Optional[AuthorizerFunctionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authorizerFunctionArn())
        .map(value => zio.aws.iot.model.primitives.AuthorizerFunctionArn(value))
    override val tokenKeyName: Optional[TokenKeyName] = zio.aws.core.internal
      .optionalFromNullable(impl.tokenKeyName())
      .map(value => zio.aws.iot.model.primitives.TokenKeyName(value))
    override val tokenSigningPublicKeys: Optional[Map[KeyName, KeyValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tokenSigningPublicKeys())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.iot.model.primitives
                .KeyName(key) -> zio.aws.iot.model.primitives.KeyValue(value)
            })
            .toMap
        )
    override val status: Optional[zio.aws.iot.model.AuthorizerStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iot.model.AuthorizerStatus.wrap(value))
    override val creationDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val lastModifiedDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val signingDisabled: Optional[BooleanKey] = zio.aws.core.internal
      .optionalFromNullable(impl.signingDisabled())
      .map(value => zio.aws.iot.model.primitives.BooleanKey(value))
    override val enableCachingForHttp: Optional[EnableCachingForHttp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableCachingForHttp())
        .map(value => zio.aws.iot.model.primitives.EnableCachingForHttp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AuthorizerDescription
  ): zio.aws.iot.model.AuthorizerDescription.ReadOnly = new Wrapper(impl)
}
