package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.AwsJobRateIncreaseCriteriaNumberOfThings
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class AwsJobRateIncreaseCriteria(
    numberOfNotifiedThings: Optional[AwsJobRateIncreaseCriteriaNumberOfThings] =
      Optional.Absent,
    numberOfSucceededThings: Optional[
      AwsJobRateIncreaseCriteriaNumberOfThings
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AwsJobRateIncreaseCriteria = {
    import AwsJobRateIncreaseCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AwsJobRateIncreaseCriteria
      .builder()
      .optionallyWith(
        numberOfNotifiedThings.map(value =>
          AwsJobRateIncreaseCriteriaNumberOfThings.unwrap(value): Integer
        )
      )(_.numberOfNotifiedThings)
      .optionallyWith(
        numberOfSucceededThings.map(value =>
          AwsJobRateIncreaseCriteriaNumberOfThings.unwrap(value): Integer
        )
      )(_.numberOfSucceededThings)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AwsJobRateIncreaseCriteria.ReadOnly =
    zio.aws.iot.model.AwsJobRateIncreaseCriteria.wrap(buildAwsValue())
}
object AwsJobRateIncreaseCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AwsJobRateIncreaseCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AwsJobRateIncreaseCriteria =
      zio.aws.iot.model.AwsJobRateIncreaseCriteria(
        numberOfNotifiedThings.map(value => value),
        numberOfSucceededThings.map(value => value)
      )
    def numberOfNotifiedThings
        : Optional[AwsJobRateIncreaseCriteriaNumberOfThings]
    def numberOfSucceededThings
        : Optional[AwsJobRateIncreaseCriteriaNumberOfThings]
    def getNumberOfNotifiedThings
        : ZIO[Any, AwsError, AwsJobRateIncreaseCriteriaNumberOfThings] =
      AwsError.unwrapOptionField(
        "numberOfNotifiedThings",
        numberOfNotifiedThings
      )
    def getNumberOfSucceededThings
        : ZIO[Any, AwsError, AwsJobRateIncreaseCriteriaNumberOfThings] =
      AwsError.unwrapOptionField(
        "numberOfSucceededThings",
        numberOfSucceededThings
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AwsJobRateIncreaseCriteria
  ) extends zio.aws.iot.model.AwsJobRateIncreaseCriteria.ReadOnly {
    override val numberOfNotifiedThings
        : Optional[AwsJobRateIncreaseCriteriaNumberOfThings] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfNotifiedThings())
        .map(value =>
          zio.aws.iot.model.primitives
            .AwsJobRateIncreaseCriteriaNumberOfThings(value)
        )
    override val numberOfSucceededThings
        : Optional[AwsJobRateIncreaseCriteriaNumberOfThings] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfSucceededThings())
        .map(value =>
          zio.aws.iot.model.primitives
            .AwsJobRateIncreaseCriteriaNumberOfThings(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AwsJobRateIncreaseCriteria
  ): zio.aws.iot.model.AwsJobRateIncreaseCriteria.ReadOnly = new Wrapper(impl)
}
