package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BucketsAggregationType(
    termsAggregation: Optional[zio.aws.iot.model.TermsAggregation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.BucketsAggregationType = {
    import BucketsAggregationType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.BucketsAggregationType
      .builder()
      .optionallyWith(termsAggregation.map(value => value.buildAwsValue()))(
        _.termsAggregation
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.BucketsAggregationType.ReadOnly =
    zio.aws.iot.model.BucketsAggregationType.wrap(buildAwsValue())
}
object BucketsAggregationType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.BucketsAggregationType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.BucketsAggregationType = zio.aws.iot.model
      .BucketsAggregationType(termsAggregation.map(value => value.asEditable))
    def termsAggregation: Optional[zio.aws.iot.model.TermsAggregation.ReadOnly]
    def getTermsAggregation
        : ZIO[Any, AwsError, zio.aws.iot.model.TermsAggregation.ReadOnly] =
      AwsError.unwrapOptionField("termsAggregation", termsAggregation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.BucketsAggregationType
  ) extends zio.aws.iot.model.BucketsAggregationType.ReadOnly {
    override val termsAggregation
        : Optional[zio.aws.iot.model.TermsAggregation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.termsAggregation())
        .map(value => zio.aws.iot.model.TermsAggregation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.BucketsAggregationType
  ): zio.aws.iot.model.BucketsAggregationType.ReadOnly = new Wrapper(impl)
}
