package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  DateType,
  CertificateId,
  CertificateArn,
  CertificatePem,
  CustomerVersion,
  AwsAccountId,
  GenerationId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CACertificateDescription(
    certificateArn: Optional[CertificateArn] = Optional.Absent,
    certificateId: Optional[CertificateId] = Optional.Absent,
    status: Optional[zio.aws.iot.model.CACertificateStatus] = Optional.Absent,
    certificatePem: Optional[CertificatePem] = Optional.Absent,
    ownedBy: Optional[AwsAccountId] = Optional.Absent,
    creationDate: Optional[DateType] = Optional.Absent,
    autoRegistrationStatus: Optional[zio.aws.iot.model.AutoRegistrationStatus] =
      Optional.Absent,
    lastModifiedDate: Optional[DateType] = Optional.Absent,
    customerVersion: Optional[CustomerVersion] = Optional.Absent,
    generationId: Optional[GenerationId] = Optional.Absent,
    validity: Optional[zio.aws.iot.model.CertificateValidity] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CACertificateDescription = {
    import CACertificateDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CACertificateDescription
      .builder()
      .optionallyWith(
        certificateArn.map(value =>
          CertificateArn.unwrap(value): java.lang.String
        )
      )(_.certificateArn)
      .optionallyWith(
        certificateId.map(value =>
          CertificateId.unwrap(value): java.lang.String
        )
      )(_.certificateId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        certificatePem.map(value =>
          CertificatePem.unwrap(value): java.lang.String
        )
      )(_.certificatePem)
      .optionallyWith(
        ownedBy.map(value => AwsAccountId.unwrap(value): java.lang.String)
      )(_.ownedBy)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(autoRegistrationStatus.map(value => value.unwrap))(
        _.autoRegistrationStatus
      )
      .optionallyWith(
        lastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        customerVersion.map(value => CustomerVersion.unwrap(value): Integer)
      )(_.customerVersion)
      .optionallyWith(
        generationId.map(value => GenerationId.unwrap(value): java.lang.String)
      )(_.generationId)
      .optionallyWith(validity.map(value => value.buildAwsValue()))(_.validity)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CACertificateDescription.ReadOnly =
    zio.aws.iot.model.CACertificateDescription.wrap(buildAwsValue())
}
object CACertificateDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CACertificateDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CACertificateDescription =
      zio.aws.iot.model.CACertificateDescription(
        certificateArn.map(value => value),
        certificateId.map(value => value),
        status.map(value => value),
        certificatePem.map(value => value),
        ownedBy.map(value => value),
        creationDate.map(value => value),
        autoRegistrationStatus.map(value => value),
        lastModifiedDate.map(value => value),
        customerVersion.map(value => value),
        generationId.map(value => value),
        validity.map(value => value.asEditable)
      )
    def certificateArn: Optional[CertificateArn]
    def certificateId: Optional[CertificateId]
    def status: Optional[zio.aws.iot.model.CACertificateStatus]
    def certificatePem: Optional[CertificatePem]
    def ownedBy: Optional[AwsAccountId]
    def creationDate: Optional[DateType]
    def autoRegistrationStatus
        : Optional[zio.aws.iot.model.AutoRegistrationStatus]
    def lastModifiedDate: Optional[DateType]
    def customerVersion: Optional[CustomerVersion]
    def generationId: Optional[GenerationId]
    def validity: Optional[zio.aws.iot.model.CertificateValidity.ReadOnly]
    def getCertificateArn: ZIO[Any, AwsError, CertificateArn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getCertificateId: ZIO[Any, AwsError, CertificateId] =
      AwsError.unwrapOptionField("certificateId", certificateId)
    def getStatus: ZIO[Any, AwsError, zio.aws.iot.model.CACertificateStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCertificatePem: ZIO[Any, AwsError, CertificatePem] =
      AwsError.unwrapOptionField("certificatePem", certificatePem)
    def getOwnedBy: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("ownedBy", ownedBy)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getAutoRegistrationStatus
        : ZIO[Any, AwsError, zio.aws.iot.model.AutoRegistrationStatus] =
      AwsError.unwrapOptionField(
        "autoRegistrationStatus",
        autoRegistrationStatus
      )
    def getLastModifiedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getCustomerVersion: ZIO[Any, AwsError, CustomerVersion] =
      AwsError.unwrapOptionField("customerVersion", customerVersion)
    def getGenerationId: ZIO[Any, AwsError, GenerationId] =
      AwsError.unwrapOptionField("generationId", generationId)
    def getValidity
        : ZIO[Any, AwsError, zio.aws.iot.model.CertificateValidity.ReadOnly] =
      AwsError.unwrapOptionField("validity", validity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CACertificateDescription
  ) extends zio.aws.iot.model.CACertificateDescription.ReadOnly {
    override val certificateArn: Optional[CertificateArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateArn())
        .map(value => zio.aws.iot.model.primitives.CertificateArn(value))
    override val certificateId: Optional[CertificateId] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateId())
      .map(value => zio.aws.iot.model.primitives.CertificateId(value))
    override val status: Optional[zio.aws.iot.model.CACertificateStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iot.model.CACertificateStatus.wrap(value))
    override val certificatePem: Optional[CertificatePem] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificatePem())
        .map(value => zio.aws.iot.model.primitives.CertificatePem(value))
    override val ownedBy: Optional[AwsAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.ownedBy())
      .map(value => zio.aws.iot.model.primitives.AwsAccountId(value))
    override val creationDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val autoRegistrationStatus
        : Optional[zio.aws.iot.model.AutoRegistrationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoRegistrationStatus())
        .map(value => zio.aws.iot.model.AutoRegistrationStatus.wrap(value))
    override val lastModifiedDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val customerVersion: Optional[CustomerVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customerVersion())
        .map(value => zio.aws.iot.model.primitives.CustomerVersion(value))
    override val generationId: Optional[GenerationId] = zio.aws.core.internal
      .optionalFromNullable(impl.generationId())
      .map(value => zio.aws.iot.model.primitives.GenerationId(value))
    override val validity
        : Optional[zio.aws.iot.model.CertificateValidity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validity())
        .map(value => zio.aws.iot.model.CertificateValidity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CACertificateDescription
  ): zio.aws.iot.model.CACertificateDescription.ReadOnly = new Wrapper(impl)
}
