package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{DateType, CertificateId, CertificateArn}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Certificate(
    certificateArn: Optional[CertificateArn] = Optional.Absent,
    certificateId: Optional[CertificateId] = Optional.Absent,
    status: Optional[zio.aws.iot.model.CertificateStatus] = Optional.Absent,
    certificateMode: Optional[zio.aws.iot.model.CertificateMode] =
      Optional.Absent,
    creationDate: Optional[DateType] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.Certificate = {
    import Certificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.Certificate
      .builder()
      .optionallyWith(
        certificateArn.map(value =>
          CertificateArn.unwrap(value): java.lang.String
        )
      )(_.certificateArn)
      .optionallyWith(
        certificateId.map(value =>
          CertificateId.unwrap(value): java.lang.String
        )
      )(_.certificateId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(certificateMode.map(value => value.unwrap))(
        _.certificateMode
      )
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.Certificate.ReadOnly =
    zio.aws.iot.model.Certificate.wrap(buildAwsValue())
}
object Certificate {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.Certificate] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.Certificate =
      zio.aws.iot.model.Certificate(
        certificateArn.map(value => value),
        certificateId.map(value => value),
        status.map(value => value),
        certificateMode.map(value => value),
        creationDate.map(value => value)
      )
    def certificateArn: Optional[CertificateArn]
    def certificateId: Optional[CertificateId]
    def status: Optional[zio.aws.iot.model.CertificateStatus]
    def certificateMode: Optional[zio.aws.iot.model.CertificateMode]
    def creationDate: Optional[DateType]
    def getCertificateArn: ZIO[Any, AwsError, CertificateArn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getCertificateId: ZIO[Any, AwsError, CertificateId] =
      AwsError.unwrapOptionField("certificateId", certificateId)
    def getStatus: ZIO[Any, AwsError, zio.aws.iot.model.CertificateStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCertificateMode
        : ZIO[Any, AwsError, zio.aws.iot.model.CertificateMode] =
      AwsError.unwrapOptionField("certificateMode", certificateMode)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.Certificate
  ) extends zio.aws.iot.model.Certificate.ReadOnly {
    override val certificateArn: Optional[CertificateArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateArn())
        .map(value => zio.aws.iot.model.primitives.CertificateArn(value))
    override val certificateId: Optional[CertificateId] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateId())
      .map(value => zio.aws.iot.model.primitives.CertificateId(value))
    override val status: Optional[zio.aws.iot.model.CertificateStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iot.model.CertificateStatus.wrap(value))
    override val certificateMode: Optional[zio.aws.iot.model.CertificateMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateMode())
        .map(value => zio.aws.iot.model.CertificateMode.wrap(value))
    override val creationDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.Certificate
  ): zio.aws.iot.model.Certificate.ReadOnly = new Wrapper(impl)
}
