package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ClientRequestToken,
  CustomMetricDisplayName,
  MetricName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateCustomMetricRequest(
    metricName: MetricName,
    displayName: Optional[CustomMetricDisplayName] = Optional.Absent,
    metricType: zio.aws.iot.model.CustomMetricType,
    tags: Optional[Iterable[zio.aws.iot.model.Tag]] = Optional.Absent,
    clientRequestToken: ClientRequestToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateCustomMetricRequest = {
    import CreateCustomMetricRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateCustomMetricRequest
      .builder()
      .metricName(MetricName.unwrap(metricName): java.lang.String)
      .optionallyWith(
        displayName.map(value =>
          CustomMetricDisplayName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .metricType(metricType.unwrap)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .clientRequestToken(
        ClientRequestToken.unwrap(clientRequestToken): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateCustomMetricRequest.ReadOnly =
    zio.aws.iot.model.CreateCustomMetricRequest.wrap(buildAwsValue())
}
object CreateCustomMetricRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateCustomMetricRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateCustomMetricRequest =
      zio.aws.iot.model.CreateCustomMetricRequest(
        metricName,
        displayName.map(value => value),
        metricType,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientRequestToken
      )
    def metricName: MetricName
    def displayName: Optional[CustomMetricDisplayName]
    def metricType: zio.aws.iot.model.CustomMetricType
    def tags: Optional[List[zio.aws.iot.model.Tag.ReadOnly]]
    def clientRequestToken: ClientRequestToken
    def getMetricName: ZIO[Any, Nothing, MetricName] = ZIO.succeed(metricName)
    def getDisplayName: ZIO[Any, AwsError, CustomMetricDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getMetricType: ZIO[Any, Nothing, zio.aws.iot.model.CustomMetricType] =
      ZIO.succeed(metricType)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iot.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientRequestToken: ZIO[Any, Nothing, ClientRequestToken] =
      ZIO.succeed(clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateCustomMetricRequest
  ) extends zio.aws.iot.model.CreateCustomMetricRequest.ReadOnly {
    override val metricName: MetricName =
      zio.aws.iot.model.primitives.MetricName(impl.metricName())
    override val displayName: Optional[CustomMetricDisplayName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.displayName())
        .map(value =>
          zio.aws.iot.model.primitives.CustomMetricDisplayName(value)
        )
    override val metricType: zio.aws.iot.model.CustomMetricType =
      zio.aws.iot.model.CustomMetricType.wrap(impl.metricType())
    override val tags: Optional[List[zio.aws.iot.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.Tag.wrap(item)
          }.toList
        )
    override val clientRequestToken: ClientRequestToken =
      zio.aws.iot.model.primitives.ClientRequestToken(impl.clientRequestToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateCustomMetricRequest
  ): zio.aws.iot.model.CreateCustomMetricRequest.ReadOnly = new Wrapper(impl)
}
