package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ThingGroupId,
  IndexName,
  ThingGroupArn,
  QueryVersion,
  QueryString,
  ThingGroupName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateDynamicThingGroupResponse(
    thingGroupName: Optional[ThingGroupName] = Optional.Absent,
    thingGroupArn: Optional[ThingGroupArn] = Optional.Absent,
    thingGroupId: Optional[ThingGroupId] = Optional.Absent,
    indexName: Optional[IndexName] = Optional.Absent,
    queryString: Optional[QueryString] = Optional.Absent,
    queryVersion: Optional[QueryVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateDynamicThingGroupResponse = {
    import CreateDynamicThingGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateDynamicThingGroupResponse
      .builder()
      .optionallyWith(
        thingGroupName.map(value =>
          ThingGroupName.unwrap(value): java.lang.String
        )
      )(_.thingGroupName)
      .optionallyWith(
        thingGroupArn.map(value =>
          ThingGroupArn.unwrap(value): java.lang.String
        )
      )(_.thingGroupArn)
      .optionallyWith(
        thingGroupId.map(value => ThingGroupId.unwrap(value): java.lang.String)
      )(_.thingGroupId)
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .optionallyWith(
        queryString.map(value => QueryString.unwrap(value): java.lang.String)
      )(_.queryString)
      .optionallyWith(
        queryVersion.map(value => QueryVersion.unwrap(value): java.lang.String)
      )(_.queryVersion)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateDynamicThingGroupResponse.ReadOnly =
    zio.aws.iot.model.CreateDynamicThingGroupResponse.wrap(buildAwsValue())
}
object CreateDynamicThingGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateDynamicThingGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateDynamicThingGroupResponse =
      zio.aws.iot.model.CreateDynamicThingGroupResponse(
        thingGroupName.map(value => value),
        thingGroupArn.map(value => value),
        thingGroupId.map(value => value),
        indexName.map(value => value),
        queryString.map(value => value),
        queryVersion.map(value => value)
      )
    def thingGroupName: Optional[ThingGroupName]
    def thingGroupArn: Optional[ThingGroupArn]
    def thingGroupId: Optional[ThingGroupId]
    def indexName: Optional[IndexName]
    def queryString: Optional[QueryString]
    def queryVersion: Optional[QueryVersion]
    def getThingGroupName: ZIO[Any, AwsError, ThingGroupName] =
      AwsError.unwrapOptionField("thingGroupName", thingGroupName)
    def getThingGroupArn: ZIO[Any, AwsError, ThingGroupArn] =
      AwsError.unwrapOptionField("thingGroupArn", thingGroupArn)
    def getThingGroupId: ZIO[Any, AwsError, ThingGroupId] =
      AwsError.unwrapOptionField("thingGroupId", thingGroupId)
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getQueryString: ZIO[Any, AwsError, QueryString] =
      AwsError.unwrapOptionField("queryString", queryString)
    def getQueryVersion: ZIO[Any, AwsError, QueryVersion] =
      AwsError.unwrapOptionField("queryVersion", queryVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateDynamicThingGroupResponse
  ) extends zio.aws.iot.model.CreateDynamicThingGroupResponse.ReadOnly {
    override val thingGroupName: Optional[ThingGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thingGroupName())
        .map(value => zio.aws.iot.model.primitives.ThingGroupName(value))
    override val thingGroupArn: Optional[ThingGroupArn] = zio.aws.core.internal
      .optionalFromNullable(impl.thingGroupArn())
      .map(value => zio.aws.iot.model.primitives.ThingGroupArn(value))
    override val thingGroupId: Optional[ThingGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.thingGroupId())
      .map(value => zio.aws.iot.model.primitives.ThingGroupId(value))
    override val indexName: Optional[IndexName] = zio.aws.core.internal
      .optionalFromNullable(impl.indexName())
      .map(value => zio.aws.iot.model.primitives.IndexName(value))
    override val queryString: Optional[QueryString] = zio.aws.core.internal
      .optionalFromNullable(impl.queryString())
      .map(value => zio.aws.iot.model.primitives.QueryString(value))
    override val queryVersion: Optional[QueryVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.queryVersion())
      .map(value => zio.aws.iot.model.primitives.QueryVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateDynamicThingGroupResponse
  ): zio.aws.iot.model.CreateDynamicThingGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
