package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{RoleArn, MitigationActionName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateMitigationActionRequest(
    actionName: MitigationActionName,
    roleArn: RoleArn,
    actionParams: zio.aws.iot.model.MitigationActionParams,
    tags: Optional[Iterable[zio.aws.iot.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateMitigationActionRequest = {
    import CreateMitigationActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateMitigationActionRequest
      .builder()
      .actionName(MitigationActionName.unwrap(actionName): java.lang.String)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .actionParams(actionParams.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateMitigationActionRequest.ReadOnly =
    zio.aws.iot.model.CreateMitigationActionRequest.wrap(buildAwsValue())
}
object CreateMitigationActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateMitigationActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateMitigationActionRequest =
      zio.aws.iot.model.CreateMitigationActionRequest(
        actionName,
        roleArn,
        actionParams.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def actionName: MitigationActionName
    def roleArn: RoleArn
    def actionParams: zio.aws.iot.model.MitigationActionParams.ReadOnly
    def tags: Optional[List[zio.aws.iot.model.Tag.ReadOnly]]
    def getActionName: ZIO[Any, Nothing, MitigationActionName] =
      ZIO.succeed(actionName)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getActionParams
        : ZIO[Any, Nothing, zio.aws.iot.model.MitigationActionParams.ReadOnly] =
      ZIO.succeed(actionParams)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iot.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateMitigationActionRequest
  ) extends zio.aws.iot.model.CreateMitigationActionRequest.ReadOnly {
    override val actionName: MitigationActionName =
      zio.aws.iot.model.primitives.MitigationActionName(impl.actionName())
    override val roleArn: RoleArn =
      zio.aws.iot.model.primitives.RoleArn(impl.roleArn())
    override val actionParams
        : zio.aws.iot.model.MitigationActionParams.ReadOnly =
      zio.aws.iot.model.MitigationActionParams.wrap(impl.actionParams())
    override val tags: Optional[List[zio.aws.iot.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateMitigationActionRequest
  ): zio.aws.iot.model.CreateMitigationActionRequest.ReadOnly = new Wrapper(
    impl
  )
}
