package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  OTAUpdateId,
  RoleArn,
  OTAUpdateDescription,
  Value,
  AttributeKey,
  Target
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateOtaUpdateRequest(
    otaUpdateId: OTAUpdateId,
    description: Optional[OTAUpdateDescription] = Optional.Absent,
    targets: Iterable[Target],
    protocols: Optional[Iterable[zio.aws.iot.model.Protocol]] = Optional.Absent,
    targetSelection: Optional[zio.aws.iot.model.TargetSelection] =
      Optional.Absent,
    awsJobExecutionsRolloutConfig: Optional[
      zio.aws.iot.model.AwsJobExecutionsRolloutConfig
    ] = Optional.Absent,
    awsJobPresignedUrlConfig: Optional[
      zio.aws.iot.model.AwsJobPresignedUrlConfig
    ] = Optional.Absent,
    awsJobAbortConfig: Optional[zio.aws.iot.model.AwsJobAbortConfig] =
      Optional.Absent,
    awsJobTimeoutConfig: Optional[zio.aws.iot.model.AwsJobTimeoutConfig] =
      Optional.Absent,
    files: Iterable[zio.aws.iot.model.OTAUpdateFile],
    roleArn: RoleArn,
    additionalParameters: Optional[Map[AttributeKey, Value]] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.iot.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateOtaUpdateRequest = {
    import CreateOtaUpdateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateOtaUpdateRequest
      .builder()
      .otaUpdateId(OTAUpdateId.unwrap(otaUpdateId): java.lang.String)
      .optionallyWith(
        description.map(value =>
          OTAUpdateDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .targets(targets.map { item =>
        Target.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        protocols.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.protocolsWithStrings)
      .optionallyWith(targetSelection.map(value => value.unwrap))(
        _.targetSelection
      )
      .optionallyWith(
        awsJobExecutionsRolloutConfig.map(value => value.buildAwsValue())
      )(_.awsJobExecutionsRolloutConfig)
      .optionallyWith(
        awsJobPresignedUrlConfig.map(value => value.buildAwsValue())
      )(_.awsJobPresignedUrlConfig)
      .optionallyWith(awsJobAbortConfig.map(value => value.buildAwsValue()))(
        _.awsJobAbortConfig
      )
      .optionallyWith(awsJobTimeoutConfig.map(value => value.buildAwsValue()))(
        _.awsJobTimeoutConfig
      )
      .files(files.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        additionalParameters.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeKey.unwrap(key): java.lang.String) -> (Value
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.additionalParameters)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateOtaUpdateRequest.ReadOnly =
    zio.aws.iot.model.CreateOtaUpdateRequest.wrap(buildAwsValue())
}
object CreateOtaUpdateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateOtaUpdateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateOtaUpdateRequest =
      zio.aws.iot.model.CreateOtaUpdateRequest(
        otaUpdateId,
        description.map(value => value),
        targets,
        protocols.map(value => value),
        targetSelection.map(value => value),
        awsJobExecutionsRolloutConfig.map(value => value.asEditable),
        awsJobPresignedUrlConfig.map(value => value.asEditable),
        awsJobAbortConfig.map(value => value.asEditable),
        awsJobTimeoutConfig.map(value => value.asEditable),
        files.map { item =>
          item.asEditable
        },
        roleArn,
        additionalParameters.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def otaUpdateId: OTAUpdateId
    def description: Optional[OTAUpdateDescription]
    def targets: List[Target]
    def protocols: Optional[List[zio.aws.iot.model.Protocol]]
    def targetSelection: Optional[zio.aws.iot.model.TargetSelection]
    def awsJobExecutionsRolloutConfig
        : Optional[zio.aws.iot.model.AwsJobExecutionsRolloutConfig.ReadOnly]
    def awsJobPresignedUrlConfig
        : Optional[zio.aws.iot.model.AwsJobPresignedUrlConfig.ReadOnly]
    def awsJobAbortConfig
        : Optional[zio.aws.iot.model.AwsJobAbortConfig.ReadOnly]
    def awsJobTimeoutConfig
        : Optional[zio.aws.iot.model.AwsJobTimeoutConfig.ReadOnly]
    def files: List[zio.aws.iot.model.OTAUpdateFile.ReadOnly]
    def roleArn: RoleArn
    def additionalParameters: Optional[Map[AttributeKey, Value]]
    def tags: Optional[List[zio.aws.iot.model.Tag.ReadOnly]]
    def getOtaUpdateId: ZIO[Any, Nothing, OTAUpdateId] =
      ZIO.succeed(otaUpdateId)
    def getDescription: ZIO[Any, AwsError, OTAUpdateDescription] =
      AwsError.unwrapOptionField("description", description)
    def getTargets: ZIO[Any, Nothing, List[Target]] = ZIO.succeed(targets)
    def getProtocols: ZIO[Any, AwsError, List[zio.aws.iot.model.Protocol]] =
      AwsError.unwrapOptionField("protocols", protocols)
    def getTargetSelection
        : ZIO[Any, AwsError, zio.aws.iot.model.TargetSelection] =
      AwsError.unwrapOptionField("targetSelection", targetSelection)
    def getAwsJobExecutionsRolloutConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.AwsJobExecutionsRolloutConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsJobExecutionsRolloutConfig",
      awsJobExecutionsRolloutConfig
    )
    def getAwsJobPresignedUrlConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.AwsJobPresignedUrlConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsJobPresignedUrlConfig",
      awsJobPresignedUrlConfig
    )
    def getAwsJobAbortConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.AwsJobAbortConfig.ReadOnly] =
      AwsError.unwrapOptionField("awsJobAbortConfig", awsJobAbortConfig)
    def getAwsJobTimeoutConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.AwsJobTimeoutConfig.ReadOnly] =
      AwsError.unwrapOptionField("awsJobTimeoutConfig", awsJobTimeoutConfig)
    def getFiles
        : ZIO[Any, Nothing, List[zio.aws.iot.model.OTAUpdateFile.ReadOnly]] =
      ZIO.succeed(files)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getAdditionalParameters: ZIO[Any, AwsError, Map[AttributeKey, Value]] =
      AwsError.unwrapOptionField("additionalParameters", additionalParameters)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iot.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateOtaUpdateRequest
  ) extends zio.aws.iot.model.CreateOtaUpdateRequest.ReadOnly {
    override val otaUpdateId: OTAUpdateId =
      zio.aws.iot.model.primitives.OTAUpdateId(impl.otaUpdateId())
    override val description: Optional[OTAUpdateDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.iot.model.primitives.OTAUpdateDescription(value))
    override val targets: List[Target] = impl
      .targets()
      .asScala
      .map { item =>
        zio.aws.iot.model.primitives.Target(item)
      }
      .toList
    override val protocols: Optional[List[zio.aws.iot.model.Protocol]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocols())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.Protocol.wrap(item)
          }.toList
        )
    override val targetSelection: Optional[zio.aws.iot.model.TargetSelection] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetSelection())
        .map(value => zio.aws.iot.model.TargetSelection.wrap(value))
    override val awsJobExecutionsRolloutConfig
        : Optional[zio.aws.iot.model.AwsJobExecutionsRolloutConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsJobExecutionsRolloutConfig())
        .map(value =>
          zio.aws.iot.model.AwsJobExecutionsRolloutConfig.wrap(value)
        )
    override val awsJobPresignedUrlConfig
        : Optional[zio.aws.iot.model.AwsJobPresignedUrlConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsJobPresignedUrlConfig())
        .map(value => zio.aws.iot.model.AwsJobPresignedUrlConfig.wrap(value))
    override val awsJobAbortConfig
        : Optional[zio.aws.iot.model.AwsJobAbortConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsJobAbortConfig())
        .map(value => zio.aws.iot.model.AwsJobAbortConfig.wrap(value))
    override val awsJobTimeoutConfig
        : Optional[zio.aws.iot.model.AwsJobTimeoutConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsJobTimeoutConfig())
        .map(value => zio.aws.iot.model.AwsJobTimeoutConfig.wrap(value))
    override val files: List[zio.aws.iot.model.OTAUpdateFile.ReadOnly] = impl
      .files()
      .asScala
      .map { item =>
        zio.aws.iot.model.OTAUpdateFile.wrap(item)
      }
      .toList
    override val roleArn: RoleArn =
      zio.aws.iot.model.primitives.RoleArn(impl.roleArn())
    override val additionalParameters: Optional[Map[AttributeKey, Value]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalParameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.iot.model.primitives
                .AttributeKey(key) -> zio.aws.iot.model.primitives.Value(value)
            })
            .toMap
        )
    override val tags: Optional[List[zio.aws.iot.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateOtaUpdateRequest
  ): zio.aws.iot.model.CreateOtaUpdateRequest.ReadOnly = new Wrapper(impl)
}
