package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  BehaviorMetric,
  SecurityProfileDescription,
  SecurityProfileName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateSecurityProfileRequest(
    securityProfileName: SecurityProfileName,
    securityProfileDescription: Optional[SecurityProfileDescription] =
      Optional.Absent,
    behaviors: Optional[Iterable[zio.aws.iot.model.Behavior]] = Optional.Absent,
    alertTargets: Optional[
      Map[zio.aws.iot.model.AlertTargetType, zio.aws.iot.model.AlertTarget]
    ] = Optional.Absent,
    additionalMetricsToRetain: Optional[Iterable[BehaviorMetric]] =
      Optional.Absent,
    additionalMetricsToRetainV2: Optional[
      Iterable[zio.aws.iot.model.MetricToRetain]
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.iot.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateSecurityProfileRequest = {
    import CreateSecurityProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateSecurityProfileRequest
      .builder()
      .securityProfileName(
        SecurityProfileName.unwrap(securityProfileName): java.lang.String
      )
      .optionallyWith(
        securityProfileDescription.map(value =>
          SecurityProfileDescription.unwrap(value): java.lang.String
        )
      )(_.securityProfileDescription)
      .optionallyWith(
        behaviors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.behaviors)
      .optionallyWith(
        alertTargets.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.alertTargetsWithStrings)
      .optionallyWith(
        additionalMetricsToRetain.map(value =>
          value.map { item =>
            BehaviorMetric.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.additionalMetricsToRetain)
      .optionallyWith(
        additionalMetricsToRetainV2.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.additionalMetricsToRetainV2)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateSecurityProfileRequest.ReadOnly =
    zio.aws.iot.model.CreateSecurityProfileRequest.wrap(buildAwsValue())
}
object CreateSecurityProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateSecurityProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateSecurityProfileRequest =
      zio.aws.iot.model.CreateSecurityProfileRequest(
        securityProfileName,
        securityProfileDescription.map(value => value),
        behaviors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        alertTargets.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        additionalMetricsToRetain.map(value => value),
        additionalMetricsToRetainV2.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def securityProfileName: SecurityProfileName
    def securityProfileDescription: Optional[SecurityProfileDescription]
    def behaviors: Optional[List[zio.aws.iot.model.Behavior.ReadOnly]]
    def alertTargets: Optional[Map[
      zio.aws.iot.model.AlertTargetType,
      zio.aws.iot.model.AlertTarget.ReadOnly
    ]]
    def additionalMetricsToRetain: Optional[List[BehaviorMetric]]
    def additionalMetricsToRetainV2
        : Optional[List[zio.aws.iot.model.MetricToRetain.ReadOnly]]
    def tags: Optional[List[zio.aws.iot.model.Tag.ReadOnly]]
    def getSecurityProfileName: ZIO[Any, Nothing, SecurityProfileName] =
      ZIO.succeed(securityProfileName)
    def getSecurityProfileDescription
        : ZIO[Any, AwsError, SecurityProfileDescription] =
      AwsError.unwrapOptionField(
        "securityProfileDescription",
        securityProfileDescription
      )
    def getBehaviors
        : ZIO[Any, AwsError, List[zio.aws.iot.model.Behavior.ReadOnly]] =
      AwsError.unwrapOptionField("behaviors", behaviors)
    def getAlertTargets: ZIO[Any, AwsError, Map[
      zio.aws.iot.model.AlertTargetType,
      zio.aws.iot.model.AlertTarget.ReadOnly
    ]] = AwsError.unwrapOptionField("alertTargets", alertTargets)
    def getAdditionalMetricsToRetain: ZIO[Any, AwsError, List[BehaviorMetric]] =
      AwsError.unwrapOptionField(
        "additionalMetricsToRetain",
        additionalMetricsToRetain
      )
    def getAdditionalMetricsToRetainV2
        : ZIO[Any, AwsError, List[zio.aws.iot.model.MetricToRetain.ReadOnly]] =
      AwsError.unwrapOptionField(
        "additionalMetricsToRetainV2",
        additionalMetricsToRetainV2
      )
    def getTags: ZIO[Any, AwsError, List[zio.aws.iot.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateSecurityProfileRequest
  ) extends zio.aws.iot.model.CreateSecurityProfileRequest.ReadOnly {
    override val securityProfileName: SecurityProfileName =
      zio.aws.iot.model.primitives
        .SecurityProfileName(impl.securityProfileName())
    override val securityProfileDescription
        : Optional[SecurityProfileDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.securityProfileDescription())
      .map(value =>
        zio.aws.iot.model.primitives.SecurityProfileDescription(value)
      )
    override val behaviors
        : Optional[List[zio.aws.iot.model.Behavior.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.behaviors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.Behavior.wrap(item)
          }.toList
        )
    override val alertTargets: Optional[Map[
      zio.aws.iot.model.AlertTargetType,
      zio.aws.iot.model.AlertTarget.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.alertTargets())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iot.model.AlertTargetType
              .wrap(key) -> zio.aws.iot.model.AlertTarget.wrap(value)
          })
          .toMap
      )
    override val additionalMetricsToRetain: Optional[List[BehaviorMetric]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalMetricsToRetain())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.primitives.BehaviorMetric(item)
          }.toList
        )
    override val additionalMetricsToRetainV2
        : Optional[List[zio.aws.iot.model.MetricToRetain.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalMetricsToRetainV2())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.MetricToRetain.wrap(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.iot.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateSecurityProfileRequest
  ): zio.aws.iot.model.CreateSecurityProfileRequest.ReadOnly = new Wrapper(impl)
}
