package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.AuditCheckName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteAuditSuppressionRequest(
    checkName: AuditCheckName,
    resourceIdentifier: zio.aws.iot.model.ResourceIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DeleteAuditSuppressionRequest = {
    import DeleteAuditSuppressionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DeleteAuditSuppressionRequest
      .builder()
      .checkName(AuditCheckName.unwrap(checkName): java.lang.String)
      .resourceIdentifier(resourceIdentifier.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DeleteAuditSuppressionRequest.ReadOnly =
    zio.aws.iot.model.DeleteAuditSuppressionRequest.wrap(buildAwsValue())
}
object DeleteAuditSuppressionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DeleteAuditSuppressionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DeleteAuditSuppressionRequest =
      zio.aws.iot.model
        .DeleteAuditSuppressionRequest(checkName, resourceIdentifier.asEditable)
    def checkName: AuditCheckName
    def resourceIdentifier: zio.aws.iot.model.ResourceIdentifier.ReadOnly
    def getCheckName: ZIO[Any, Nothing, AuditCheckName] = ZIO.succeed(checkName)
    def getResourceIdentifier
        : ZIO[Any, Nothing, zio.aws.iot.model.ResourceIdentifier.ReadOnly] =
      ZIO.succeed(resourceIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DeleteAuditSuppressionRequest
  ) extends zio.aws.iot.model.DeleteAuditSuppressionRequest.ReadOnly {
    override val checkName: AuditCheckName =
      zio.aws.iot.model.primitives.AuditCheckName(impl.checkName())
    override val resourceIdentifier
        : zio.aws.iot.model.ResourceIdentifier.ReadOnly =
      zio.aws.iot.model.ResourceIdentifier.wrap(impl.resourceIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DeleteAuditSuppressionRequest
  ): zio.aws.iot.model.DeleteAuditSuppressionRequest.ReadOnly = new Wrapper(
    impl
  )
}
