package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ForceDeleteAWSJob,
  DeleteStream,
  OTAUpdateId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteOtaUpdateRequest(
    otaUpdateId: OTAUpdateId,
    deleteStream: Optional[DeleteStream] = Optional.Absent,
    forceDeleteAWSJob: Optional[ForceDeleteAWSJob] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DeleteOtaUpdateRequest = {
    import DeleteOtaUpdateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DeleteOtaUpdateRequest
      .builder()
      .otaUpdateId(OTAUpdateId.unwrap(otaUpdateId): java.lang.String)
      .optionallyWith(
        deleteStream.map(value => DeleteStream.unwrap(value): java.lang.Boolean)
      )(_.deleteStream)
      .optionallyWith(
        forceDeleteAWSJob.map(value =>
          ForceDeleteAWSJob.unwrap(value): java.lang.Boolean
        )
      )(_.forceDeleteAWSJob)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DeleteOtaUpdateRequest.ReadOnly =
    zio.aws.iot.model.DeleteOtaUpdateRequest.wrap(buildAwsValue())
}
object DeleteOtaUpdateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DeleteOtaUpdateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DeleteOtaUpdateRequest =
      zio.aws.iot.model.DeleteOtaUpdateRequest(
        otaUpdateId,
        deleteStream.map(value => value),
        forceDeleteAWSJob.map(value => value)
      )
    def otaUpdateId: OTAUpdateId
    def deleteStream: Optional[DeleteStream]
    def forceDeleteAWSJob: Optional[ForceDeleteAWSJob]
    def getOtaUpdateId: ZIO[Any, Nothing, OTAUpdateId] =
      ZIO.succeed(otaUpdateId)
    def getDeleteStream: ZIO[Any, AwsError, DeleteStream] =
      AwsError.unwrapOptionField("deleteStream", deleteStream)
    def getForceDeleteAWSJob: ZIO[Any, AwsError, ForceDeleteAWSJob] =
      AwsError.unwrapOptionField("forceDeleteAWSJob", forceDeleteAWSJob)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DeleteOtaUpdateRequest
  ) extends zio.aws.iot.model.DeleteOtaUpdateRequest.ReadOnly {
    override val otaUpdateId: OTAUpdateId =
      zio.aws.iot.model.primitives.OTAUpdateId(impl.otaUpdateId())
    override val deleteStream: Optional[DeleteStream] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteStream())
      .map(value => zio.aws.iot.model.primitives.DeleteStream(value))
    override val forceDeleteAWSJob: Optional[ForceDeleteAWSJob] =
      zio.aws.core.internal
        .optionalFromNullable(impl.forceDeleteAWSJob())
        .map(value => zio.aws.iot.model.primitives.ForceDeleteAWSJob(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DeleteOtaUpdateRequest
  ): zio.aws.iot.model.DeleteOtaUpdateRequest.ReadOnly = new Wrapper(impl)
}
