package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{OptionalVersion, ThingGroupName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteThingGroupRequest(
    thingGroupName: ThingGroupName,
    expectedVersion: Optional[OptionalVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DeleteThingGroupRequest = {
    import DeleteThingGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DeleteThingGroupRequest
      .builder()
      .thingGroupName(ThingGroupName.unwrap(thingGroupName): java.lang.String)
      .optionallyWith(
        expectedVersion.map(value =>
          OptionalVersion.unwrap(value): java.lang.Long
        )
      )(_.expectedVersion)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DeleteThingGroupRequest.ReadOnly =
    zio.aws.iot.model.DeleteThingGroupRequest.wrap(buildAwsValue())
}
object DeleteThingGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DeleteThingGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DeleteThingGroupRequest =
      zio.aws.iot.model.DeleteThingGroupRequest(
        thingGroupName,
        expectedVersion.map(value => value)
      )
    def thingGroupName: ThingGroupName
    def expectedVersion: Optional[OptionalVersion]
    def getThingGroupName: ZIO[Any, Nothing, ThingGroupName] =
      ZIO.succeed(thingGroupName)
    def getExpectedVersion: ZIO[Any, AwsError, OptionalVersion] =
      AwsError.unwrapOptionField("expectedVersion", expectedVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DeleteThingGroupRequest
  ) extends zio.aws.iot.model.DeleteThingGroupRequest.ReadOnly {
    override val thingGroupName: ThingGroupName =
      zio.aws.iot.model.primitives.ThingGroupName(impl.thingGroupName())
    override val expectedVersion: Optional[OptionalVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedVersion())
        .map(value => zio.aws.iot.model.primitives.OptionalVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DeleteThingGroupRequest
  ): zio.aws.iot.model.DeleteThingGroupRequest.ReadOnly = new Wrapper(impl)
}
