package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.AwsArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteTopicRuleDestinationRequest(arn: AwsArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DeleteTopicRuleDestinationRequest = {
    import DeleteTopicRuleDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DeleteTopicRuleDestinationRequest
      .builder()
      .arn(AwsArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DeleteTopicRuleDestinationRequest.ReadOnly =
    zio.aws.iot.model.DeleteTopicRuleDestinationRequest.wrap(buildAwsValue())
}
object DeleteTopicRuleDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DeleteTopicRuleDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DeleteTopicRuleDestinationRequest =
      zio.aws.iot.model.DeleteTopicRuleDestinationRequest(arn)
    def arn: AwsArn
    def getArn: ZIO[Any, Nothing, AwsArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DeleteTopicRuleDestinationRequest
  ) extends zio.aws.iot.model.DeleteTopicRuleDestinationRequest.ReadOnly {
    override val arn: AwsArn = zio.aws.iot.model.primitives.AwsArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DeleteTopicRuleDestinationRequest
  ): zio.aws.iot.model.DeleteTopicRuleDestinationRequest.ReadOnly = new Wrapper(
    impl
  )
}
