package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.BillingGroupName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeBillingGroupRequest(
    billingGroupName: BillingGroupName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeBillingGroupRequest = {
    import DescribeBillingGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeBillingGroupRequest
      .builder()
      .billingGroupName(
        BillingGroupName.unwrap(billingGroupName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeBillingGroupRequest.ReadOnly =
    zio.aws.iot.model.DescribeBillingGroupRequest.wrap(buildAwsValue())
}
object DescribeBillingGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeBillingGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeBillingGroupRequest =
      zio.aws.iot.model.DescribeBillingGroupRequest(billingGroupName)
    def billingGroupName: BillingGroupName
    def getBillingGroupName: ZIO[Any, Nothing, BillingGroupName] =
      ZIO.succeed(billingGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeBillingGroupRequest
  ) extends zio.aws.iot.model.DescribeBillingGroupRequest.ReadOnly {
    override val billingGroupName: BillingGroupName =
      zio.aws.iot.model.primitives.BillingGroupName(impl.billingGroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeBillingGroupRequest
  ): zio.aws.iot.model.DescribeBillingGroupRequest.ReadOnly = new Wrapper(impl)
}
