package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.CertificateId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeCertificateRequest(certificateId: CertificateId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeCertificateRequest = {
    import DescribeCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeCertificateRequest
      .builder()
      .certificateId(CertificateId.unwrap(certificateId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeCertificateRequest.ReadOnly =
    zio.aws.iot.model.DescribeCertificateRequest.wrap(buildAwsValue())
}
object DescribeCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeCertificateRequest =
      zio.aws.iot.model.DescribeCertificateRequest(certificateId)
    def certificateId: CertificateId
    def getCertificateId: ZIO[Any, Nothing, CertificateId] =
      ZIO.succeed(certificateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeCertificateRequest
  ) extends zio.aws.iot.model.DescribeCertificateRequest.ReadOnly {
    override val certificateId: CertificateId =
      zio.aws.iot.model.primitives.CertificateId(impl.certificateId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeCertificateRequest
  ): zio.aws.iot.model.DescribeCertificateRequest.ReadOnly = new Wrapper(impl)
}
