package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.DimensionName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeDimensionRequest(name: DimensionName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeDimensionRequest = {
    import DescribeDimensionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeDimensionRequest
      .builder()
      .name(DimensionName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeDimensionRequest.ReadOnly =
    zio.aws.iot.model.DescribeDimensionRequest.wrap(buildAwsValue())
}
object DescribeDimensionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeDimensionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeDimensionRequest =
      zio.aws.iot.model.DescribeDimensionRequest(name)
    def name: DimensionName
    def getName: ZIO[Any, Nothing, DimensionName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeDimensionRequest
  ) extends zio.aws.iot.model.DescribeDimensionRequest.ReadOnly {
    override val name: DimensionName =
      zio.aws.iot.model.primitives.DimensionName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeDimensionRequest
  ): zio.aws.iot.model.DescribeDimensionRequest.ReadOnly = new Wrapper(impl)
}
