package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.FleetMetricName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeFleetMetricRequest(metricName: FleetMetricName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeFleetMetricRequest = {
    import DescribeFleetMetricRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeFleetMetricRequest
      .builder()
      .metricName(FleetMetricName.unwrap(metricName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeFleetMetricRequest.ReadOnly =
    zio.aws.iot.model.DescribeFleetMetricRequest.wrap(buildAwsValue())
}
object DescribeFleetMetricRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeFleetMetricRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeFleetMetricRequest =
      zio.aws.iot.model.DescribeFleetMetricRequest(metricName)
    def metricName: FleetMetricName
    def getMetricName: ZIO[Any, Nothing, FleetMetricName] =
      ZIO.succeed(metricName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeFleetMetricRequest
  ) extends zio.aws.iot.model.DescribeFleetMetricRequest.ReadOnly {
    override val metricName: FleetMetricName =
      zio.aws.iot.model.primitives.FleetMetricName(impl.metricName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeFleetMetricRequest
  ): zio.aws.iot.model.DescribeFleetMetricRequest.ReadOnly = new Wrapper(impl)
}
