package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.StreamId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeStreamRequest(streamId: StreamId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeStreamRequest = {
    import DescribeStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeStreamRequest
      .builder()
      .streamId(StreamId.unwrap(streamId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeStreamRequest.ReadOnly =
    zio.aws.iot.model.DescribeStreamRequest.wrap(buildAwsValue())
}
object DescribeStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeStreamRequest =
      zio.aws.iot.model.DescribeStreamRequest(streamId)
    def streamId: StreamId
    def getStreamId: ZIO[Any, Nothing, StreamId] = ZIO.succeed(streamId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeStreamRequest
  ) extends zio.aws.iot.model.DescribeStreamRequest.ReadOnly {
    override val streamId: StreamId =
      zio.aws.iot.model.primitives.StreamId(impl.streamId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeStreamRequest
  ): zio.aws.iot.model.DescribeStreamRequest.ReadOnly = new Wrapper(impl)
}
