package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  HashKeyField,
  TableName,
  HashKeyValue,
  PayloadField,
  AwsArn,
  RangeKeyField,
  RangeKeyValue,
  DynamoOperation
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DynamoDBAction(
    tableName: TableName,
    roleArn: AwsArn,
    operation: Optional[DynamoOperation] = Optional.Absent,
    hashKeyField: HashKeyField,
    hashKeyValue: HashKeyValue,
    hashKeyType: Optional[zio.aws.iot.model.DynamoKeyType] = Optional.Absent,
    rangeKeyField: Optional[RangeKeyField] = Optional.Absent,
    rangeKeyValue: Optional[RangeKeyValue] = Optional.Absent,
    rangeKeyType: Optional[zio.aws.iot.model.DynamoKeyType] = Optional.Absent,
    payloadField: Optional[PayloadField] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DynamoDBAction = {
    import DynamoDBAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DynamoDBAction
      .builder()
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .roleArn(AwsArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        operation.map(value => DynamoOperation.unwrap(value): java.lang.String)
      )(_.operation)
      .hashKeyField(HashKeyField.unwrap(hashKeyField): java.lang.String)
      .hashKeyValue(HashKeyValue.unwrap(hashKeyValue): java.lang.String)
      .optionallyWith(hashKeyType.map(value => value.unwrap))(_.hashKeyType)
      .optionallyWith(
        rangeKeyField.map(value =>
          RangeKeyField.unwrap(value): java.lang.String
        )
      )(_.rangeKeyField)
      .optionallyWith(
        rangeKeyValue.map(value =>
          RangeKeyValue.unwrap(value): java.lang.String
        )
      )(_.rangeKeyValue)
      .optionallyWith(rangeKeyType.map(value => value.unwrap))(_.rangeKeyType)
      .optionallyWith(
        payloadField.map(value => PayloadField.unwrap(value): java.lang.String)
      )(_.payloadField)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DynamoDBAction.ReadOnly =
    zio.aws.iot.model.DynamoDBAction.wrap(buildAwsValue())
}
object DynamoDBAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DynamoDBAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DynamoDBAction =
      zio.aws.iot.model.DynamoDBAction(
        tableName,
        roleArn,
        operation.map(value => value),
        hashKeyField,
        hashKeyValue,
        hashKeyType.map(value => value),
        rangeKeyField.map(value => value),
        rangeKeyValue.map(value => value),
        rangeKeyType.map(value => value),
        payloadField.map(value => value)
      )
    def tableName: TableName
    def roleArn: AwsArn
    def operation: Optional[DynamoOperation]
    def hashKeyField: HashKeyField
    def hashKeyValue: HashKeyValue
    def hashKeyType: Optional[zio.aws.iot.model.DynamoKeyType]
    def rangeKeyField: Optional[RangeKeyField]
    def rangeKeyValue: Optional[RangeKeyValue]
    def rangeKeyType: Optional[zio.aws.iot.model.DynamoKeyType]
    def payloadField: Optional[PayloadField]
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
    def getRoleArn: ZIO[Any, Nothing, AwsArn] = ZIO.succeed(roleArn)
    def getOperation: ZIO[Any, AwsError, DynamoOperation] =
      AwsError.unwrapOptionField("operation", operation)
    def getHashKeyField: ZIO[Any, Nothing, HashKeyField] =
      ZIO.succeed(hashKeyField)
    def getHashKeyValue: ZIO[Any, Nothing, HashKeyValue] =
      ZIO.succeed(hashKeyValue)
    def getHashKeyType: ZIO[Any, AwsError, zio.aws.iot.model.DynamoKeyType] =
      AwsError.unwrapOptionField("hashKeyType", hashKeyType)
    def getRangeKeyField: ZIO[Any, AwsError, RangeKeyField] =
      AwsError.unwrapOptionField("rangeKeyField", rangeKeyField)
    def getRangeKeyValue: ZIO[Any, AwsError, RangeKeyValue] =
      AwsError.unwrapOptionField("rangeKeyValue", rangeKeyValue)
    def getRangeKeyType: ZIO[Any, AwsError, zio.aws.iot.model.DynamoKeyType] =
      AwsError.unwrapOptionField("rangeKeyType", rangeKeyType)
    def getPayloadField: ZIO[Any, AwsError, PayloadField] =
      AwsError.unwrapOptionField("payloadField", payloadField)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DynamoDBAction
  ) extends zio.aws.iot.model.DynamoDBAction.ReadOnly {
    override val tableName: TableName =
      zio.aws.iot.model.primitives.TableName(impl.tableName())
    override val roleArn: AwsArn =
      zio.aws.iot.model.primitives.AwsArn(impl.roleArn())
    override val operation: Optional[DynamoOperation] = zio.aws.core.internal
      .optionalFromNullable(impl.operation())
      .map(value => zio.aws.iot.model.primitives.DynamoOperation(value))
    override val hashKeyField: HashKeyField =
      zio.aws.iot.model.primitives.HashKeyField(impl.hashKeyField())
    override val hashKeyValue: HashKeyValue =
      zio.aws.iot.model.primitives.HashKeyValue(impl.hashKeyValue())
    override val hashKeyType: Optional[zio.aws.iot.model.DynamoKeyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hashKeyType())
        .map(value => zio.aws.iot.model.DynamoKeyType.wrap(value))
    override val rangeKeyField: Optional[RangeKeyField] = zio.aws.core.internal
      .optionalFromNullable(impl.rangeKeyField())
      .map(value => zio.aws.iot.model.primitives.RangeKeyField(value))
    override val rangeKeyValue: Optional[RangeKeyValue] = zio.aws.core.internal
      .optionalFromNullable(impl.rangeKeyValue())
      .map(value => zio.aws.iot.model.primitives.RangeKeyValue(value))
    override val rangeKeyType: Optional[zio.aws.iot.model.DynamoKeyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rangeKeyType())
        .map(value => zio.aws.iot.model.DynamoKeyType.wrap(value))
    override val payloadField: Optional[PayloadField] = zio.aws.core.internal
      .optionalFromNullable(impl.payloadField())
      .map(value => zio.aws.iot.model.primitives.PayloadField(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DynamoDBAction
  ): zio.aws.iot.model.DynamoDBAction.ReadOnly = new Wrapper(impl)
}
