package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  QueryVersion,
  AggregationField,
  QueryString,
  IndexName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetBucketsAggregationRequest(
    indexName: Optional[IndexName] = Optional.Absent,
    queryString: QueryString,
    aggregationField: AggregationField,
    queryVersion: Optional[QueryVersion] = Optional.Absent,
    bucketsAggregationType: zio.aws.iot.model.BucketsAggregationType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.GetBucketsAggregationRequest = {
    import GetBucketsAggregationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.GetBucketsAggregationRequest
      .builder()
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .queryString(QueryString.unwrap(queryString): java.lang.String)
      .aggregationField(
        AggregationField.unwrap(aggregationField): java.lang.String
      )
      .optionallyWith(
        queryVersion.map(value => QueryVersion.unwrap(value): java.lang.String)
      )(_.queryVersion)
      .bucketsAggregationType(bucketsAggregationType.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iot.model.GetBucketsAggregationRequest.ReadOnly =
    zio.aws.iot.model.GetBucketsAggregationRequest.wrap(buildAwsValue())
}
object GetBucketsAggregationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.GetBucketsAggregationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.GetBucketsAggregationRequest =
      zio.aws.iot.model.GetBucketsAggregationRequest(
        indexName.map(value => value),
        queryString,
        aggregationField,
        queryVersion.map(value => value),
        bucketsAggregationType.asEditable
      )
    def indexName: Optional[IndexName]
    def queryString: QueryString
    def aggregationField: AggregationField
    def queryVersion: Optional[QueryVersion]
    def bucketsAggregationType
        : zio.aws.iot.model.BucketsAggregationType.ReadOnly
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getQueryString: ZIO[Any, Nothing, QueryString] =
      ZIO.succeed(queryString)
    def getAggregationField: ZIO[Any, Nothing, AggregationField] =
      ZIO.succeed(aggregationField)
    def getQueryVersion: ZIO[Any, AwsError, QueryVersion] =
      AwsError.unwrapOptionField("queryVersion", queryVersion)
    def getBucketsAggregationType
        : ZIO[Any, Nothing, zio.aws.iot.model.BucketsAggregationType.ReadOnly] =
      ZIO.succeed(bucketsAggregationType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.GetBucketsAggregationRequest
  ) extends zio.aws.iot.model.GetBucketsAggregationRequest.ReadOnly {
    override val indexName: Optional[IndexName] = zio.aws.core.internal
      .optionalFromNullable(impl.indexName())
      .map(value => zio.aws.iot.model.primitives.IndexName(value))
    override val queryString: QueryString =
      zio.aws.iot.model.primitives.QueryString(impl.queryString())
    override val aggregationField: AggregationField =
      zio.aws.iot.model.primitives.AggregationField(impl.aggregationField())
    override val queryVersion: Optional[QueryVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.queryVersion())
      .map(value => zio.aws.iot.model.primitives.QueryVersion(value))
    override val bucketsAggregationType
        : zio.aws.iot.model.BucketsAggregationType.ReadOnly =
      zio.aws.iot.model.BucketsAggregationType
        .wrap(impl.bucketsAggregationType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.GetBucketsAggregationRequest
  ): zio.aws.iot.model.GetBucketsAggregationRequest.ReadOnly = new Wrapper(impl)
}
