package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.AwsArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetTopicRuleDestinationRequest(arn: AwsArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.GetTopicRuleDestinationRequest = {
    import GetTopicRuleDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.GetTopicRuleDestinationRequest
      .builder()
      .arn(AwsArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.GetTopicRuleDestinationRequest.ReadOnly =
    zio.aws.iot.model.GetTopicRuleDestinationRequest.wrap(buildAwsValue())
}
object GetTopicRuleDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.GetTopicRuleDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.GetTopicRuleDestinationRequest =
      zio.aws.iot.model.GetTopicRuleDestinationRequest(arn)
    def arn: AwsArn
    def getArn: ZIO[Any, Nothing, AwsArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.GetTopicRuleDestinationRequest
  ) extends zio.aws.iot.model.GetTopicRuleDestinationRequest.ReadOnly {
    override val arn: AwsArn = zio.aws.iot.model.primitives.AwsArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.GetTopicRuleDestinationRequest
  ): zio.aws.iot.model.GetTopicRuleDestinationRequest.ReadOnly = new Wrapper(
    impl
  )
}
