package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.Url
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class HttpAction(
    url: Url,
    confirmationUrl: Optional[Url] = Optional.Absent,
    headers: Optional[Iterable[zio.aws.iot.model.HttpActionHeader]] =
      Optional.Absent,
    auth: Optional[zio.aws.iot.model.HttpAuthorization] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.HttpAction = {
    import HttpAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.HttpAction
      .builder()
      .url(Url.unwrap(url): java.lang.String)
      .optionallyWith(
        confirmationUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.confirmationUrl)
      .optionallyWith(
        headers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.headers)
      .optionallyWith(auth.map(value => value.buildAwsValue()))(_.auth)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.HttpAction.ReadOnly =
    zio.aws.iot.model.HttpAction.wrap(buildAwsValue())
}
object HttpAction {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.HttpAction] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.HttpAction = zio.aws.iot.model.HttpAction(
      url,
      confirmationUrl.map(value => value),
      headers.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      auth.map(value => value.asEditable)
    )
    def url: Url
    def confirmationUrl: Optional[Url]
    def headers: Optional[List[zio.aws.iot.model.HttpActionHeader.ReadOnly]]
    def auth: Optional[zio.aws.iot.model.HttpAuthorization.ReadOnly]
    def getUrl: ZIO[Any, Nothing, Url] = ZIO.succeed(url)
    def getConfirmationUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("confirmationUrl", confirmationUrl)
    def getHeaders: ZIO[Any, AwsError, List[
      zio.aws.iot.model.HttpActionHeader.ReadOnly
    ]] = AwsError.unwrapOptionField("headers", headers)
    def getAuth
        : ZIO[Any, AwsError, zio.aws.iot.model.HttpAuthorization.ReadOnly] =
      AwsError.unwrapOptionField("auth", auth)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.HttpAction
  ) extends zio.aws.iot.model.HttpAction.ReadOnly {
    override val url: Url = zio.aws.iot.model.primitives.Url(impl.url())
    override val confirmationUrl: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.confirmationUrl())
      .map(value => zio.aws.iot.model.primitives.Url(value))
    override val headers
        : Optional[List[zio.aws.iot.model.HttpActionHeader.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.headers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.HttpActionHeader.wrap(item)
          }.toList
        )
    override val auth: Optional[zio.aws.iot.model.HttpAuthorization.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.auth())
        .map(value => zio.aws.iot.model.HttpAuthorization.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.HttpAction
  ): zio.aws.iot.model.HttpAction.ReadOnly = new Wrapper(impl)
}
