package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  ThingArn,
  DateType,
  ApproximateSecondsBeforeTimedOut,
  ExecutionNumber,
  VersionNumber,
  Forced,
  JobId
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class JobExecution(
    jobId: Optional[JobId] = Optional.Absent,
    status: Optional[zio.aws.iot.model.JobExecutionStatus] = Optional.Absent,
    forceCanceled: Optional[Forced] = Optional.Absent,
    statusDetails: Optional[zio.aws.iot.model.JobExecutionStatusDetails] =
      Optional.Absent,
    thingArn: Optional[ThingArn] = Optional.Absent,
    queuedAt: Optional[DateType] = Optional.Absent,
    startedAt: Optional[DateType] = Optional.Absent,
    lastUpdatedAt: Optional[DateType] = Optional.Absent,
    executionNumber: Optional[ExecutionNumber] = Optional.Absent,
    versionNumber: Optional[VersionNumber] = Optional.Absent,
    approximateSecondsBeforeTimedOut: Optional[
      ApproximateSecondsBeforeTimedOut
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.JobExecution = {
    import JobExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.JobExecution
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        forceCanceled.map(value => Forced.unwrap(value): java.lang.Boolean)
      )(_.forceCanceled)
      .optionallyWith(statusDetails.map(value => value.buildAwsValue()))(
        _.statusDetails
      )
      .optionallyWith(
        thingArn.map(value => ThingArn.unwrap(value): java.lang.String)
      )(_.thingArn)
      .optionallyWith(queuedAt.map(value => DateType.unwrap(value): Instant))(
        _.queuedAt
      )
      .optionallyWith(startedAt.map(value => DateType.unwrap(value): Instant))(
        _.startedAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => DateType.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        executionNumber.map(value =>
          ExecutionNumber.unwrap(value): java.lang.Long
        )
      )(_.executionNumber)
      .optionallyWith(
        versionNumber.map(value => VersionNumber.unwrap(value): java.lang.Long)
      )(_.versionNumber)
      .optionallyWith(
        approximateSecondsBeforeTimedOut.map(value =>
          ApproximateSecondsBeforeTimedOut.unwrap(value): java.lang.Long
        )
      )(_.approximateSecondsBeforeTimedOut)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.JobExecution.ReadOnly =
    zio.aws.iot.model.JobExecution.wrap(buildAwsValue())
}
object JobExecution {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.JobExecution] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.JobExecution =
      zio.aws.iot.model.JobExecution(
        jobId.map(value => value),
        status.map(value => value),
        forceCanceled.map(value => value),
        statusDetails.map(value => value.asEditable),
        thingArn.map(value => value),
        queuedAt.map(value => value),
        startedAt.map(value => value),
        lastUpdatedAt.map(value => value),
        executionNumber.map(value => value),
        versionNumber.map(value => value),
        approximateSecondsBeforeTimedOut.map(value => value)
      )
    def jobId: Optional[JobId]
    def status: Optional[zio.aws.iot.model.JobExecutionStatus]
    def forceCanceled: Optional[Forced]
    def statusDetails
        : Optional[zio.aws.iot.model.JobExecutionStatusDetails.ReadOnly]
    def thingArn: Optional[ThingArn]
    def queuedAt: Optional[DateType]
    def startedAt: Optional[DateType]
    def lastUpdatedAt: Optional[DateType]
    def executionNumber: Optional[ExecutionNumber]
    def versionNumber: Optional[VersionNumber]
    def approximateSecondsBeforeTimedOut
        : Optional[ApproximateSecondsBeforeTimedOut]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getStatus: ZIO[Any, AwsError, zio.aws.iot.model.JobExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getForceCanceled: ZIO[Any, AwsError, Forced] =
      AwsError.unwrapOptionField("forceCanceled", forceCanceled)
    def getStatusDetails: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.JobExecutionStatusDetails.ReadOnly
    ] = AwsError.unwrapOptionField("statusDetails", statusDetails)
    def getThingArn: ZIO[Any, AwsError, ThingArn] =
      AwsError.unwrapOptionField("thingArn", thingArn)
    def getQueuedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("queuedAt", queuedAt)
    def getStartedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getExecutionNumber: ZIO[Any, AwsError, ExecutionNumber] =
      AwsError.unwrapOptionField("executionNumber", executionNumber)
    def getVersionNumber: ZIO[Any, AwsError, VersionNumber] =
      AwsError.unwrapOptionField("versionNumber", versionNumber)
    def getApproximateSecondsBeforeTimedOut
        : ZIO[Any, AwsError, ApproximateSecondsBeforeTimedOut] =
      AwsError.unwrapOptionField(
        "approximateSecondsBeforeTimedOut",
        approximateSecondsBeforeTimedOut
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.JobExecution
  ) extends zio.aws.iot.model.JobExecution.ReadOnly {
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.iot.model.primitives.JobId(value))
    override val status: Optional[zio.aws.iot.model.JobExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iot.model.JobExecutionStatus.wrap(value))
    override val forceCanceled: Optional[Forced] = zio.aws.core.internal
      .optionalFromNullable(impl.forceCanceled())
      .map(value => zio.aws.iot.model.primitives.Forced(value))
    override val statusDetails
        : Optional[zio.aws.iot.model.JobExecutionStatusDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusDetails())
        .map(value => zio.aws.iot.model.JobExecutionStatusDetails.wrap(value))
    override val thingArn: Optional[ThingArn] = zio.aws.core.internal
      .optionalFromNullable(impl.thingArn())
      .map(value => zio.aws.iot.model.primitives.ThingArn(value))
    override val queuedAt: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.queuedAt())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val startedAt: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.startedAt())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val lastUpdatedAt: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val executionNumber: Optional[ExecutionNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionNumber())
        .map(value => zio.aws.iot.model.primitives.ExecutionNumber(value))
    override val versionNumber: Optional[VersionNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.versionNumber())
      .map(value => zio.aws.iot.model.primitives.VersionNumber(value))
    override val approximateSecondsBeforeTimedOut
        : Optional[ApproximateSecondsBeforeTimedOut] = zio.aws.core.internal
      .optionalFromNullable(impl.approximateSecondsBeforeTimedOut())
      .map(value =>
        zio.aws.iot.model.primitives.ApproximateSecondsBeforeTimedOut(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.JobExecution
  ): zio.aws.iot.model.JobExecution.ReadOnly = new Wrapper(impl)
}
