package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  RemovedThings,
  RejectedThings,
  ProcessingTargetName,
  QueuedThings,
  CanceledThings,
  InProgressThings,
  TimedOutThings,
  FailedThings,
  SucceededThings
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class JobProcessDetails(
    processingTargets: Optional[Iterable[ProcessingTargetName]] =
      Optional.Absent,
    numberOfCanceledThings: Optional[CanceledThings] = Optional.Absent,
    numberOfSucceededThings: Optional[SucceededThings] = Optional.Absent,
    numberOfFailedThings: Optional[FailedThings] = Optional.Absent,
    numberOfRejectedThings: Optional[RejectedThings] = Optional.Absent,
    numberOfQueuedThings: Optional[QueuedThings] = Optional.Absent,
    numberOfInProgressThings: Optional[InProgressThings] = Optional.Absent,
    numberOfRemovedThings: Optional[RemovedThings] = Optional.Absent,
    numberOfTimedOutThings: Optional[TimedOutThings] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.JobProcessDetails = {
    import JobProcessDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.JobProcessDetails
      .builder()
      .optionallyWith(
        processingTargets.map(value =>
          value.map { item =>
            ProcessingTargetName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.processingTargets)
      .optionallyWith(
        numberOfCanceledThings.map(value =>
          CanceledThings.unwrap(value): Integer
        )
      )(_.numberOfCanceledThings)
      .optionallyWith(
        numberOfSucceededThings.map(value =>
          SucceededThings.unwrap(value): Integer
        )
      )(_.numberOfSucceededThings)
      .optionallyWith(
        numberOfFailedThings.map(value => FailedThings.unwrap(value): Integer)
      )(_.numberOfFailedThings)
      .optionallyWith(
        numberOfRejectedThings.map(value =>
          RejectedThings.unwrap(value): Integer
        )
      )(_.numberOfRejectedThings)
      .optionallyWith(
        numberOfQueuedThings.map(value => QueuedThings.unwrap(value): Integer)
      )(_.numberOfQueuedThings)
      .optionallyWith(
        numberOfInProgressThings.map(value =>
          InProgressThings.unwrap(value): Integer
        )
      )(_.numberOfInProgressThings)
      .optionallyWith(
        numberOfRemovedThings.map(value => RemovedThings.unwrap(value): Integer)
      )(_.numberOfRemovedThings)
      .optionallyWith(
        numberOfTimedOutThings.map(value =>
          TimedOutThings.unwrap(value): Integer
        )
      )(_.numberOfTimedOutThings)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.JobProcessDetails.ReadOnly =
    zio.aws.iot.model.JobProcessDetails.wrap(buildAwsValue())
}
object JobProcessDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.JobProcessDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.JobProcessDetails =
      zio.aws.iot.model.JobProcessDetails(
        processingTargets.map(value => value),
        numberOfCanceledThings.map(value => value),
        numberOfSucceededThings.map(value => value),
        numberOfFailedThings.map(value => value),
        numberOfRejectedThings.map(value => value),
        numberOfQueuedThings.map(value => value),
        numberOfInProgressThings.map(value => value),
        numberOfRemovedThings.map(value => value),
        numberOfTimedOutThings.map(value => value)
      )
    def processingTargets: Optional[List[ProcessingTargetName]]
    def numberOfCanceledThings: Optional[CanceledThings]
    def numberOfSucceededThings: Optional[SucceededThings]
    def numberOfFailedThings: Optional[FailedThings]
    def numberOfRejectedThings: Optional[RejectedThings]
    def numberOfQueuedThings: Optional[QueuedThings]
    def numberOfInProgressThings: Optional[InProgressThings]
    def numberOfRemovedThings: Optional[RemovedThings]
    def numberOfTimedOutThings: Optional[TimedOutThings]
    def getProcessingTargets: ZIO[Any, AwsError, List[ProcessingTargetName]] =
      AwsError.unwrapOptionField("processingTargets", processingTargets)
    def getNumberOfCanceledThings: ZIO[Any, AwsError, CanceledThings] = AwsError
      .unwrapOptionField("numberOfCanceledThings", numberOfCanceledThings)
    def getNumberOfSucceededThings: ZIO[Any, AwsError, SucceededThings] =
      AwsError.unwrapOptionField(
        "numberOfSucceededThings",
        numberOfSucceededThings
      )
    def getNumberOfFailedThings: ZIO[Any, AwsError, FailedThings] =
      AwsError.unwrapOptionField("numberOfFailedThings", numberOfFailedThings)
    def getNumberOfRejectedThings: ZIO[Any, AwsError, RejectedThings] = AwsError
      .unwrapOptionField("numberOfRejectedThings", numberOfRejectedThings)
    def getNumberOfQueuedThings: ZIO[Any, AwsError, QueuedThings] =
      AwsError.unwrapOptionField("numberOfQueuedThings", numberOfQueuedThings)
    def getNumberOfInProgressThings: ZIO[Any, AwsError, InProgressThings] =
      AwsError.unwrapOptionField(
        "numberOfInProgressThings",
        numberOfInProgressThings
      )
    def getNumberOfRemovedThings: ZIO[Any, AwsError, RemovedThings] =
      AwsError.unwrapOptionField("numberOfRemovedThings", numberOfRemovedThings)
    def getNumberOfTimedOutThings: ZIO[Any, AwsError, TimedOutThings] = AwsError
      .unwrapOptionField("numberOfTimedOutThings", numberOfTimedOutThings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.JobProcessDetails
  ) extends zio.aws.iot.model.JobProcessDetails.ReadOnly {
    override val processingTargets: Optional[List[ProcessingTargetName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processingTargets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.primitives.ProcessingTargetName(item)
          }.toList
        )
    override val numberOfCanceledThings: Optional[CanceledThings] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfCanceledThings())
        .map(value => zio.aws.iot.model.primitives.CanceledThings(value))
    override val numberOfSucceededThings: Optional[SucceededThings] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfSucceededThings())
        .map(value => zio.aws.iot.model.primitives.SucceededThings(value))
    override val numberOfFailedThings: Optional[FailedThings] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfFailedThings())
        .map(value => zio.aws.iot.model.primitives.FailedThings(value))
    override val numberOfRejectedThings: Optional[RejectedThings] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfRejectedThings())
        .map(value => zio.aws.iot.model.primitives.RejectedThings(value))
    override val numberOfQueuedThings: Optional[QueuedThings] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfQueuedThings())
        .map(value => zio.aws.iot.model.primitives.QueuedThings(value))
    override val numberOfInProgressThings: Optional[InProgressThings] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfInProgressThings())
        .map(value => zio.aws.iot.model.primitives.InProgressThings(value))
    override val numberOfRemovedThings: Optional[RemovedThings] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfRemovedThings())
        .map(value => zio.aws.iot.model.primitives.RemovedThings(value))
    override val numberOfTimedOutThings: Optional[TimedOutThings] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfTimedOutThings())
        .map(value => zio.aws.iot.model.primitives.TimedOutThings(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.JobProcessDetails
  ): zio.aws.iot.model.JobProcessDetails.ReadOnly = new Wrapper(impl)
}
