package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListBillingGroupsResponse(
    billingGroups: Optional[Iterable[zio.aws.iot.model.GroupNameAndArn]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListBillingGroupsResponse = {
    import ListBillingGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListBillingGroupsResponse
      .builder()
      .optionallyWith(
        billingGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.billingGroups)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListBillingGroupsResponse.ReadOnly =
    zio.aws.iot.model.ListBillingGroupsResponse.wrap(buildAwsValue())
}
object ListBillingGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListBillingGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListBillingGroupsResponse =
      zio.aws.iot.model.ListBillingGroupsResponse(
        billingGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def billingGroups
        : Optional[List[zio.aws.iot.model.GroupNameAndArn.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getBillingGroups
        : ZIO[Any, AwsError, List[zio.aws.iot.model.GroupNameAndArn.ReadOnly]] =
      AwsError.unwrapOptionField("billingGroups", billingGroups)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListBillingGroupsResponse
  ) extends zio.aws.iot.model.ListBillingGroupsResponse.ReadOnly {
    override val billingGroups
        : Optional[List[zio.aws.iot.model.GroupNameAndArn.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.billingGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.GroupNameAndArn.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListBillingGroupsResponse
  ): zio.aws.iot.model.ListBillingGroupsResponse.ReadOnly = new Wrapper(impl)
}
