package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.Marker
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListCaCertificatesResponse(
    certificates: Optional[Iterable[zio.aws.iot.model.CACertificate]] =
      Optional.Absent,
    nextMarker: Optional[Marker] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListCaCertificatesResponse = {
    import ListCaCertificatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListCaCertificatesResponse
      .builder()
      .optionallyWith(
        certificates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.certificates)
      .optionallyWith(
        nextMarker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListCaCertificatesResponse.ReadOnly =
    zio.aws.iot.model.ListCaCertificatesResponse.wrap(buildAwsValue())
}
object ListCaCertificatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListCaCertificatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListCaCertificatesResponse =
      zio.aws.iot.model.ListCaCertificatesResponse(
        certificates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value)
      )
    def certificates: Optional[List[zio.aws.iot.model.CACertificate.ReadOnly]]
    def nextMarker: Optional[Marker]
    def getCertificates
        : ZIO[Any, AwsError, List[zio.aws.iot.model.CACertificate.ReadOnly]] =
      AwsError.unwrapOptionField("certificates", certificates)
    def getNextMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListCaCertificatesResponse
  ) extends zio.aws.iot.model.ListCaCertificatesResponse.ReadOnly {
    override val certificates
        : Optional[List[zio.aws.iot.model.CACertificate.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.CACertificate.wrap(item)
          }.toList
        )
    override val nextMarker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.iot.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListCaCertificatesResponse
  ): zio.aws.iot.model.ListCaCertificatesResponse.ReadOnly = new Wrapper(impl)
}
