package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListJobExecutionsForThingResponse(
    executionSummaries: Optional[
      Iterable[zio.aws.iot.model.JobExecutionSummaryForThing]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListJobExecutionsForThingResponse = {
    import ListJobExecutionsForThingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListJobExecutionsForThingResponse
      .builder()
      .optionallyWith(
        executionSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.executionSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListJobExecutionsForThingResponse.ReadOnly =
    zio.aws.iot.model.ListJobExecutionsForThingResponse.wrap(buildAwsValue())
}
object ListJobExecutionsForThingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListJobExecutionsForThingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListJobExecutionsForThingResponse =
      zio.aws.iot.model.ListJobExecutionsForThingResponse(
        executionSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def executionSummaries
        : Optional[List[zio.aws.iot.model.JobExecutionSummaryForThing.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getExecutionSummaries: ZIO[Any, AwsError, List[
      zio.aws.iot.model.JobExecutionSummaryForThing.ReadOnly
    ]] = AwsError.unwrapOptionField("executionSummaries", executionSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListJobExecutionsForThingResponse
  ) extends zio.aws.iot.model.ListJobExecutionsForThingResponse.ReadOnly {
    override val executionSummaries: Optional[
      List[zio.aws.iot.model.JobExecutionSummaryForThing.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.executionSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.JobExecutionSummaryForThing.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListJobExecutionsForThingResponse
  ): zio.aws.iot.model.ListJobExecutionsForThingResponse.ReadOnly = new Wrapper(
    impl
  )
}
