package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListManagedJobTemplatesResponse(
    managedJobTemplates: Optional[
      Iterable[zio.aws.iot.model.ManagedJobTemplateSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListManagedJobTemplatesResponse = {
    import ListManagedJobTemplatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListManagedJobTemplatesResponse
      .builder()
      .optionallyWith(
        managedJobTemplates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.managedJobTemplates)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListManagedJobTemplatesResponse.ReadOnly =
    zio.aws.iot.model.ListManagedJobTemplatesResponse.wrap(buildAwsValue())
}
object ListManagedJobTemplatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListManagedJobTemplatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListManagedJobTemplatesResponse =
      zio.aws.iot.model.ListManagedJobTemplatesResponse(
        managedJobTemplates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def managedJobTemplates
        : Optional[List[zio.aws.iot.model.ManagedJobTemplateSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getManagedJobTemplates: ZIO[Any, AwsError, List[
      zio.aws.iot.model.ManagedJobTemplateSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("managedJobTemplates", managedJobTemplates)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListManagedJobTemplatesResponse
  ) extends zio.aws.iot.model.ListManagedJobTemplatesResponse.ReadOnly {
    override val managedJobTemplates
        : Optional[List[zio.aws.iot.model.ManagedJobTemplateSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedJobTemplates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.ManagedJobTemplateSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListManagedJobTemplatesResponse
  ): zio.aws.iot.model.ListManagedJobTemplatesResponse.ReadOnly = new Wrapper(
    impl
  )
}
