package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{Principal, RegistryMaxResults, NextToken}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListPrincipalThingsRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[RegistryMaxResults] = Optional.Absent,
    principal: Principal
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListPrincipalThingsRequest = {
    import ListPrincipalThingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListPrincipalThingsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => RegistryMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .principal(Principal.unwrap(principal): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListPrincipalThingsRequest.ReadOnly =
    zio.aws.iot.model.ListPrincipalThingsRequest.wrap(buildAwsValue())
}
object ListPrincipalThingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListPrincipalThingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListPrincipalThingsRequest =
      zio.aws.iot.model.ListPrincipalThingsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        principal
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[RegistryMaxResults]
    def principal: Principal
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, RegistryMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getPrincipal: ZIO[Any, Nothing, Principal] = ZIO.succeed(principal)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListPrincipalThingsRequest
  ) extends zio.aws.iot.model.ListPrincipalThingsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val maxResults: Optional[RegistryMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value => zio.aws.iot.model.primitives.RegistryMaxResults(value))
    override val principal: Principal =
      zio.aws.iot.model.primitives.Principal(impl.principal())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListPrincipalThingsRequest
  ): zio.aws.iot.model.ListPrincipalThingsRequest.ReadOnly = new Wrapper(impl)
}
