package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{RegistryMaxResults, NextToken}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListThingRegistrationTasksRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[RegistryMaxResults] = Optional.Absent,
    status: Optional[zio.aws.iot.model.Status] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksRequest = {
    import ListThingRegistrationTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => RegistryMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListThingRegistrationTasksRequest.ReadOnly =
    zio.aws.iot.model.ListThingRegistrationTasksRequest.wrap(buildAwsValue())
}
object ListThingRegistrationTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListThingRegistrationTasksRequest =
      zio.aws.iot.model.ListThingRegistrationTasksRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        status.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[RegistryMaxResults]
    def status: Optional[zio.aws.iot.model.Status]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, RegistryMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getStatus: ZIO[Any, AwsError, zio.aws.iot.model.Status] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksRequest
  ) extends zio.aws.iot.model.ListThingRegistrationTasksRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val maxResults: Optional[RegistryMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value => zio.aws.iot.model.primitives.RegistryMaxResults(value))
    override val status: Optional[zio.aws.iot.model.Status] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iot.model.Status.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksRequest
  ): zio.aws.iot.model.ListThingRegistrationTasksRequest.ReadOnly = new Wrapper(
    impl
  )
}
