package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  ThingTypeName,
  RegistryMaxResults,
  NextToken
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListThingTypesRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[RegistryMaxResults] = Optional.Absent,
    thingTypeName: Optional[ThingTypeName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListThingTypesRequest = {
    import ListThingTypesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListThingTypesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => RegistryMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        thingTypeName.map(value =>
          ThingTypeName.unwrap(value): java.lang.String
        )
      )(_.thingTypeName)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListThingTypesRequest.ReadOnly =
    zio.aws.iot.model.ListThingTypesRequest.wrap(buildAwsValue())
}
object ListThingTypesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListThingTypesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListThingTypesRequest =
      zio.aws.iot.model.ListThingTypesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        thingTypeName.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[RegistryMaxResults]
    def thingTypeName: Optional[ThingTypeName]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, RegistryMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getThingTypeName: ZIO[Any, AwsError, ThingTypeName] =
      AwsError.unwrapOptionField("thingTypeName", thingTypeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListThingTypesRequest
  ) extends zio.aws.iot.model.ListThingTypesRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val maxResults: Optional[RegistryMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value => zio.aws.iot.model.primitives.RegistryMaxResults(value))
    override val thingTypeName: Optional[ThingTypeName] = zio.aws.core.internal
      .optionalFromNullable(impl.thingTypeName())
      .map(value => zio.aws.iot.model.primitives.ThingTypeName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListThingTypesRequest
  ): zio.aws.iot.model.ListThingTypesRequest.ReadOnly = new Wrapper(impl)
}
