package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.AwsArn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LoggingOptionsPayload(
    roleArn: AwsArn,
    logLevel: Optional[zio.aws.iot.model.LogLevel] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.LoggingOptionsPayload = {
    import LoggingOptionsPayload.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.LoggingOptionsPayload
      .builder()
      .roleArn(AwsArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(logLevel.map(value => value.unwrap))(_.logLevel)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.LoggingOptionsPayload.ReadOnly =
    zio.aws.iot.model.LoggingOptionsPayload.wrap(buildAwsValue())
}
object LoggingOptionsPayload {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.LoggingOptionsPayload
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.LoggingOptionsPayload = zio.aws.iot.model
      .LoggingOptionsPayload(roleArn, logLevel.map(value => value))
    def roleArn: AwsArn
    def logLevel: Optional[zio.aws.iot.model.LogLevel]
    def getRoleArn: ZIO[Any, Nothing, AwsArn] = ZIO.succeed(roleArn)
    def getLogLevel: ZIO[Any, AwsError, zio.aws.iot.model.LogLevel] =
      AwsError.unwrapOptionField("logLevel", logLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.LoggingOptionsPayload
  ) extends zio.aws.iot.model.LoggingOptionsPayload.ReadOnly {
    override val roleArn: AwsArn =
      zio.aws.iot.model.primitives.AwsArn(impl.roleArn())
    override val logLevel: Optional[zio.aws.iot.model.LogLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logLevel())
        .map(value => zio.aws.iot.model.LogLevel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.LoggingOptionsPayload
  ): zio.aws.iot.model.LoggingOptionsPayload.ReadOnly = new Wrapper(impl)
}
