package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.BehaviorMetric
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MetricToRetain(
    metric: BehaviorMetric,
    metricDimension: Optional[zio.aws.iot.model.MetricDimension] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.MetricToRetain = {
    import MetricToRetain.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.MetricToRetain
      .builder()
      .metric(BehaviorMetric.unwrap(metric): java.lang.String)
      .optionallyWith(metricDimension.map(value => value.buildAwsValue()))(
        _.metricDimension
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.MetricToRetain.ReadOnly =
    zio.aws.iot.model.MetricToRetain.wrap(buildAwsValue())
}
object MetricToRetain {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.MetricToRetain
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.MetricToRetain = zio.aws.iot.model
      .MetricToRetain(metric, metricDimension.map(value => value.asEditable))
    def metric: BehaviorMetric
    def metricDimension: Optional[zio.aws.iot.model.MetricDimension.ReadOnly]
    def getMetric: ZIO[Any, Nothing, BehaviorMetric] = ZIO.succeed(metric)
    def getMetricDimension
        : ZIO[Any, AwsError, zio.aws.iot.model.MetricDimension.ReadOnly] =
      AwsError.unwrapOptionField("metricDimension", metricDimension)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.MetricToRetain
  ) extends zio.aws.iot.model.MetricToRetain.ReadOnly {
    override val metric: BehaviorMetric =
      zio.aws.iot.model.primitives.BehaviorMetric(impl.metric())
    override val metricDimension
        : Optional[zio.aws.iot.model.MetricDimension.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricDimension())
        .map(value => zio.aws.iot.model.MetricDimension.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.MetricToRetain
  ): zio.aws.iot.model.MetricToRetain.ReadOnly = new Wrapper(impl)
}
