package zio.aws.iot.model
import scala.jdk.CollectionConverters.*
sealed trait MitigationActionType {
  def unwrap: software.amazon.awssdk.services.iot.model.MitigationActionType
}
object MitigationActionType {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.MitigationActionType
  ): zio.aws.iot.model.MitigationActionType = value match {
    case software.amazon.awssdk.services.iot.model.MitigationActionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.MitigationActionType.UPDATE_DEVICE_CERTIFICATE =>
      val r = UPDATE_DEVICE_CERTIFICATE
      r
    case software.amazon.awssdk.services.iot.model.MitigationActionType.UPDATE_CA_CERTIFICATE =>
      val r = UPDATE_CA_CERTIFICATE
      r
    case software.amazon.awssdk.services.iot.model.MitigationActionType.ADD_THINGS_TO_THING_GROUP =>
      val r = ADD_THINGS_TO_THING_GROUP
      r
    case software.amazon.awssdk.services.iot.model.MitigationActionType.REPLACE_DEFAULT_POLICY_VERSION =>
      val r = REPLACE_DEFAULT_POLICY_VERSION
      r
    case software.amazon.awssdk.services.iot.model.MitigationActionType.ENABLE_IOT_LOGGING =>
      val r = ENABLE_IOT_LOGGING
      r
    case software.amazon.awssdk.services.iot.model.MitigationActionType.PUBLISH_FINDING_TO_SNS =>
      val r = PUBLISH_FINDING_TO_SNS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iot.model.MitigationActionType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.MitigationActionType =
      software.amazon.awssdk.services.iot.model.MitigationActionType.UNKNOWN_TO_SDK_VERSION
  }
  case object UPDATE_DEVICE_CERTIFICATE
      extends zio.aws.iot.model.MitigationActionType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.MitigationActionType =
      software.amazon.awssdk.services.iot.model.MitigationActionType.UPDATE_DEVICE_CERTIFICATE
  }
  case object UPDATE_CA_CERTIFICATE
      extends zio.aws.iot.model.MitigationActionType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.MitigationActionType =
      software.amazon.awssdk.services.iot.model.MitigationActionType.UPDATE_CA_CERTIFICATE
  }
  case object ADD_THINGS_TO_THING_GROUP
      extends zio.aws.iot.model.MitigationActionType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.MitigationActionType =
      software.amazon.awssdk.services.iot.model.MitigationActionType.ADD_THINGS_TO_THING_GROUP
  }
  case object REPLACE_DEFAULT_POLICY_VERSION
      extends zio.aws.iot.model.MitigationActionType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.MitigationActionType =
      software.amazon.awssdk.services.iot.model.MitigationActionType.REPLACE_DEFAULT_POLICY_VERSION
  }
  case object ENABLE_IOT_LOGGING
      extends zio.aws.iot.model.MitigationActionType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.MitigationActionType =
      software.amazon.awssdk.services.iot.model.MitigationActionType.ENABLE_IOT_LOGGING
  }
  case object PUBLISH_FINDING_TO_SNS
      extends zio.aws.iot.model.MitigationActionType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.MitigationActionType =
      software.amazon.awssdk.services.iot.model.MitigationActionType.PUBLISH_FINDING_TO_SNS
  }
}
