package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{PolicyArn, PolicyName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Policy(
    policyName: Optional[PolicyName] = Optional.Absent,
    policyArn: Optional[PolicyArn] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.Policy = {
    import Policy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.Policy
      .builder()
      .optionallyWith(
        policyName.map(value => PolicyName.unwrap(value): java.lang.String)
      )(_.policyName)
      .optionallyWith(
        policyArn.map(value => PolicyArn.unwrap(value): java.lang.String)
      )(_.policyArn)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.Policy.ReadOnly =
    zio.aws.iot.model.Policy.wrap(buildAwsValue())
}
object Policy {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.Policy] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.Policy = zio.aws.iot.model
      .Policy(policyName.map(value => value), policyArn.map(value => value))
    def policyName: Optional[PolicyName]
    def policyArn: Optional[PolicyArn]
    def getPolicyName: ZIO[Any, AwsError, PolicyName] =
      AwsError.unwrapOptionField("policyName", policyName)
    def getPolicyArn: ZIO[Any, AwsError, PolicyArn] =
      AwsError.unwrapOptionField("policyArn", policyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.Policy
  ) extends zio.aws.iot.model.Policy.ReadOnly {
    override val policyName: Optional[PolicyName] = zio.aws.core.internal
      .optionalFromNullable(impl.policyName())
      .map(value => zio.aws.iot.model.primitives.PolicyName(value))
    override val policyArn: Optional[PolicyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.policyArn())
      .map(value => zio.aws.iot.model.primitives.PolicyArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.Policy
  ): zio.aws.iot.model.Policy.ReadOnly = new Wrapper(impl)
}
