package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  AssetPropertyAlias,
  AssetPropertyId,
  AssetId,
  AssetPropertyEntryId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutAssetPropertyValueEntry(
    entryId: Optional[AssetPropertyEntryId] = Optional.Absent,
    assetId: Optional[AssetId] = Optional.Absent,
    propertyId: Optional[AssetPropertyId] = Optional.Absent,
    propertyAlias: Optional[AssetPropertyAlias] = Optional.Absent,
    propertyValues: Iterable[zio.aws.iot.model.AssetPropertyValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.PutAssetPropertyValueEntry = {
    import PutAssetPropertyValueEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.PutAssetPropertyValueEntry
      .builder()
      .optionallyWith(
        entryId.map(value =>
          AssetPropertyEntryId.unwrap(value): java.lang.String
        )
      )(_.entryId)
      .optionallyWith(
        assetId.map(value => AssetId.unwrap(value): java.lang.String)
      )(_.assetId)
      .optionallyWith(
        propertyId.map(value => AssetPropertyId.unwrap(value): java.lang.String)
      )(_.propertyId)
      .optionallyWith(
        propertyAlias.map(value =>
          AssetPropertyAlias.unwrap(value): java.lang.String
        )
      )(_.propertyAlias)
      .propertyValues(propertyValues.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.PutAssetPropertyValueEntry.ReadOnly =
    zio.aws.iot.model.PutAssetPropertyValueEntry.wrap(buildAwsValue())
}
object PutAssetPropertyValueEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.PutAssetPropertyValueEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.PutAssetPropertyValueEntry =
      zio.aws.iot.model.PutAssetPropertyValueEntry(
        entryId.map(value => value),
        assetId.map(value => value),
        propertyId.map(value => value),
        propertyAlias.map(value => value),
        propertyValues.map { item =>
          item.asEditable
        }
      )
    def entryId: Optional[AssetPropertyEntryId]
    def assetId: Optional[AssetId]
    def propertyId: Optional[AssetPropertyId]
    def propertyAlias: Optional[AssetPropertyAlias]
    def propertyValues: List[zio.aws.iot.model.AssetPropertyValue.ReadOnly]
    def getEntryId: ZIO[Any, AwsError, AssetPropertyEntryId] =
      AwsError.unwrapOptionField("entryId", entryId)
    def getAssetId: ZIO[Any, AwsError, AssetId] =
      AwsError.unwrapOptionField("assetId", assetId)
    def getPropertyId: ZIO[Any, AwsError, AssetPropertyId] =
      AwsError.unwrapOptionField("propertyId", propertyId)
    def getPropertyAlias: ZIO[Any, AwsError, AssetPropertyAlias] =
      AwsError.unwrapOptionField("propertyAlias", propertyAlias)
    def getPropertyValues: ZIO[Any, Nothing, List[
      zio.aws.iot.model.AssetPropertyValue.ReadOnly
    ]] = ZIO.succeed(propertyValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.PutAssetPropertyValueEntry
  ) extends zio.aws.iot.model.PutAssetPropertyValueEntry.ReadOnly {
    override val entryId: Optional[AssetPropertyEntryId] = zio.aws.core.internal
      .optionalFromNullable(impl.entryId())
      .map(value => zio.aws.iot.model.primitives.AssetPropertyEntryId(value))
    override val assetId: Optional[AssetId] = zio.aws.core.internal
      .optionalFromNullable(impl.assetId())
      .map(value => zio.aws.iot.model.primitives.AssetId(value))
    override val propertyId: Optional[AssetPropertyId] = zio.aws.core.internal
      .optionalFromNullable(impl.propertyId())
      .map(value => zio.aws.iot.model.primitives.AssetPropertyId(value))
    override val propertyAlias: Optional[AssetPropertyAlias] =
      zio.aws.core.internal
        .optionalFromNullable(impl.propertyAlias())
        .map(value => zio.aws.iot.model.primitives.AssetPropertyAlias(value))
    override val propertyValues
        : List[zio.aws.iot.model.AssetPropertyValue.ReadOnly] = impl
      .propertyValues()
      .asScala
      .map { item =>
        zio.aws.iot.model.AssetPropertyValue.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.PutAssetPropertyValueEntry
  ): zio.aws.iot.model.PutAssetPropertyValueEntry.ReadOnly = new Wrapper(impl)
}
