package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{Message, CertificateId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RejectCertificateTransferRequest(
    certificateId: CertificateId,
    rejectReason: Optional[Message] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.RejectCertificateTransferRequest = {
    import RejectCertificateTransferRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.RejectCertificateTransferRequest
      .builder()
      .certificateId(CertificateId.unwrap(certificateId): java.lang.String)
      .optionallyWith(
        rejectReason.map(value => Message.unwrap(value): java.lang.String)
      )(_.rejectReason)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.RejectCertificateTransferRequest.ReadOnly =
    zio.aws.iot.model.RejectCertificateTransferRequest.wrap(buildAwsValue())
}
object RejectCertificateTransferRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.RejectCertificateTransferRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.RejectCertificateTransferRequest =
      zio.aws.iot.model.RejectCertificateTransferRequest(
        certificateId,
        rejectReason.map(value => value)
      )
    def certificateId: CertificateId
    def rejectReason: Optional[Message]
    def getCertificateId: ZIO[Any, Nothing, CertificateId] =
      ZIO.succeed(certificateId)
    def getRejectReason: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("rejectReason", rejectReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.RejectCertificateTransferRequest
  ) extends zio.aws.iot.model.RejectCertificateTransferRequest.ReadOnly {
    override val certificateId: CertificateId =
      zio.aws.iot.model.primitives.CertificateId(impl.certificateId())
    override val rejectReason: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.rejectReason())
      .map(value => zio.aws.iot.model.primitives.Message(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.RejectCertificateTransferRequest
  ): zio.aws.iot.model.RejectCertificateTransferRequest.ReadOnly = new Wrapper(
    impl
  )
}
