package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ThingArn,
  ThingName,
  ThingGroupArn,
  ThingGroupName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RemoveThingFromThingGroupRequest(
    thingGroupName: Optional[ThingGroupName] = Optional.Absent,
    thingGroupArn: Optional[ThingGroupArn] = Optional.Absent,
    thingName: Optional[ThingName] = Optional.Absent,
    thingArn: Optional[ThingArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.RemoveThingFromThingGroupRequest = {
    import RemoveThingFromThingGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.RemoveThingFromThingGroupRequest
      .builder()
      .optionallyWith(
        thingGroupName.map(value =>
          ThingGroupName.unwrap(value): java.lang.String
        )
      )(_.thingGroupName)
      .optionallyWith(
        thingGroupArn.map(value =>
          ThingGroupArn.unwrap(value): java.lang.String
        )
      )(_.thingGroupArn)
      .optionallyWith(
        thingName.map(value => ThingName.unwrap(value): java.lang.String)
      )(_.thingName)
      .optionallyWith(
        thingArn.map(value => ThingArn.unwrap(value): java.lang.String)
      )(_.thingArn)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.RemoveThingFromThingGroupRequest.ReadOnly =
    zio.aws.iot.model.RemoveThingFromThingGroupRequest.wrap(buildAwsValue())
}
object RemoveThingFromThingGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.RemoveThingFromThingGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.RemoveThingFromThingGroupRequest =
      zio.aws.iot.model.RemoveThingFromThingGroupRequest(
        thingGroupName.map(value => value),
        thingGroupArn.map(value => value),
        thingName.map(value => value),
        thingArn.map(value => value)
      )
    def thingGroupName: Optional[ThingGroupName]
    def thingGroupArn: Optional[ThingGroupArn]
    def thingName: Optional[ThingName]
    def thingArn: Optional[ThingArn]
    def getThingGroupName: ZIO[Any, AwsError, ThingGroupName] =
      AwsError.unwrapOptionField("thingGroupName", thingGroupName)
    def getThingGroupArn: ZIO[Any, AwsError, ThingGroupArn] =
      AwsError.unwrapOptionField("thingGroupArn", thingGroupArn)
    def getThingName: ZIO[Any, AwsError, ThingName] =
      AwsError.unwrapOptionField("thingName", thingName)
    def getThingArn: ZIO[Any, AwsError, ThingArn] =
      AwsError.unwrapOptionField("thingArn", thingArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.RemoveThingFromThingGroupRequest
  ) extends zio.aws.iot.model.RemoveThingFromThingGroupRequest.ReadOnly {
    override val thingGroupName: Optional[ThingGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thingGroupName())
        .map(value => zio.aws.iot.model.primitives.ThingGroupName(value))
    override val thingGroupArn: Optional[ThingGroupArn] = zio.aws.core.internal
      .optionalFromNullable(impl.thingGroupArn())
      .map(value => zio.aws.iot.model.primitives.ThingGroupArn(value))
    override val thingName: Optional[ThingName] = zio.aws.core.internal
      .optionalFromNullable(impl.thingName())
      .map(value => zio.aws.iot.model.primitives.ThingName(value))
    override val thingArn: Optional[ThingArn] = zio.aws.core.internal
      .optionalFromNullable(impl.thingArn())
      .map(value => zio.aws.iot.model.primitives.ThingArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.RemoveThingFromThingGroupRequest
  ): zio.aws.iot.model.RemoveThingFromThingGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
