package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{S3Version, S3Key, S3Bucket}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class S3Location(
    bucket: Optional[S3Bucket] = Optional.Absent,
    key: Optional[S3Key] = Optional.Absent,
    version: Optional[S3Version] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.S3Location = {
    import S3Location.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.S3Location
      .builder()
      .optionallyWith(
        bucket.map(value => S3Bucket.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(key.map(value => S3Key.unwrap(value): java.lang.String))(
        _.key
      )
      .optionallyWith(
        version.map(value => S3Version.unwrap(value): java.lang.String)
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.S3Location.ReadOnly =
    zio.aws.iot.model.S3Location.wrap(buildAwsValue())
}
object S3Location {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.S3Location] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.S3Location = zio.aws.iot.model.S3Location(
      bucket.map(value => value),
      key.map(value => value),
      version.map(value => value)
    )
    def bucket: Optional[S3Bucket]
    def key: Optional[S3Key]
    def version: Optional[S3Version]
    def getBucket: ZIO[Any, AwsError, S3Bucket] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getKey: ZIO[Any, AwsError, S3Key] =
      AwsError.unwrapOptionField("key", key)
    def getVersion: ZIO[Any, AwsError, S3Version] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.S3Location
  ) extends zio.aws.iot.model.S3Location.ReadOnly {
    override val bucket: Optional[S3Bucket] = zio.aws.core.internal
      .optionalFromNullable(impl.bucket())
      .map(value => zio.aws.iot.model.primitives.S3Bucket(value))
    override val key: Optional[S3Key] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.iot.model.primitives.S3Key(value))
    override val version: Optional[S3Version] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.iot.model.primitives.S3Version(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.S3Location
  ): zio.aws.iot.model.S3Location.ReadOnly = new Wrapper(impl)
}
