package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  Seconds,
  PolicyDocument,
  PrincipalId,
  IsAuthenticated
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class TestInvokeAuthorizerResponse(
    isAuthenticated: Optional[IsAuthenticated] = Optional.Absent,
    principalId: Optional[PrincipalId] = Optional.Absent,
    policyDocuments: Optional[Iterable[PolicyDocument]] = Optional.Absent,
    refreshAfterInSeconds: Optional[Seconds] = Optional.Absent,
    disconnectAfterInSeconds: Optional[Seconds] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.TestInvokeAuthorizerResponse = {
    import TestInvokeAuthorizerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.TestInvokeAuthorizerResponse
      .builder()
      .optionallyWith(
        isAuthenticated.map(value =>
          IsAuthenticated.unwrap(value): java.lang.Boolean
        )
      )(_.isAuthenticated)
      .optionallyWith(
        principalId.map(value => PrincipalId.unwrap(value): java.lang.String)
      )(_.principalId)
      .optionallyWith(
        policyDocuments.map(value =>
          value.map { item =>
            PolicyDocument.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.policyDocuments)
      .optionallyWith(
        refreshAfterInSeconds.map(value => Seconds.unwrap(value): Integer)
      )(_.refreshAfterInSeconds)
      .optionallyWith(
        disconnectAfterInSeconds.map(value => Seconds.unwrap(value): Integer)
      )(_.disconnectAfterInSeconds)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.TestInvokeAuthorizerResponse.ReadOnly =
    zio.aws.iot.model.TestInvokeAuthorizerResponse.wrap(buildAwsValue())
}
object TestInvokeAuthorizerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.TestInvokeAuthorizerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.TestInvokeAuthorizerResponse =
      zio.aws.iot.model.TestInvokeAuthorizerResponse(
        isAuthenticated.map(value => value),
        principalId.map(value => value),
        policyDocuments.map(value => value),
        refreshAfterInSeconds.map(value => value),
        disconnectAfterInSeconds.map(value => value)
      )
    def isAuthenticated: Optional[IsAuthenticated]
    def principalId: Optional[PrincipalId]
    def policyDocuments: Optional[List[PolicyDocument]]
    def refreshAfterInSeconds: Optional[Seconds]
    def disconnectAfterInSeconds: Optional[Seconds]
    def getIsAuthenticated: ZIO[Any, AwsError, IsAuthenticated] =
      AwsError.unwrapOptionField("isAuthenticated", isAuthenticated)
    def getPrincipalId: ZIO[Any, AwsError, PrincipalId] =
      AwsError.unwrapOptionField("principalId", principalId)
    def getPolicyDocuments: ZIO[Any, AwsError, List[PolicyDocument]] =
      AwsError.unwrapOptionField("policyDocuments", policyDocuments)
    def getRefreshAfterInSeconds: ZIO[Any, AwsError, Seconds] =
      AwsError.unwrapOptionField("refreshAfterInSeconds", refreshAfterInSeconds)
    def getDisconnectAfterInSeconds: ZIO[Any, AwsError, Seconds] = AwsError
      .unwrapOptionField("disconnectAfterInSeconds", disconnectAfterInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.TestInvokeAuthorizerResponse
  ) extends zio.aws.iot.model.TestInvokeAuthorizerResponse.ReadOnly {
    override val isAuthenticated: Optional[IsAuthenticated] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isAuthenticated())
        .map(value => zio.aws.iot.model.primitives.IsAuthenticated(value))
    override val principalId: Optional[PrincipalId] = zio.aws.core.internal
      .optionalFromNullable(impl.principalId())
      .map(value => zio.aws.iot.model.primitives.PrincipalId(value))
    override val policyDocuments: Optional[List[PolicyDocument]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyDocuments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.primitives.PolicyDocument(item)
          }.toList
        )
    override val refreshAfterInSeconds: Optional[Seconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.refreshAfterInSeconds())
        .map(value => zio.aws.iot.model.primitives.Seconds(value))
    override val disconnectAfterInSeconds: Optional[Seconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disconnectAfterInSeconds())
        .map(value => zio.aws.iot.model.primitives.Seconds(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.TestInvokeAuthorizerResponse
  ): zio.aws.iot.model.TestInvokeAuthorizerResponse.ReadOnly = new Wrapper(impl)
}
