package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  JsonDocument,
  ThingTypeName,
  AttributeName,
  ThingName,
  ThingId,
  AttributeValue,
  ThingGroupName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ThingDocument(
    thingName: Optional[ThingName] = Optional.Absent,
    thingId: Optional[ThingId] = Optional.Absent,
    thingTypeName: Optional[ThingTypeName] = Optional.Absent,
    thingGroupNames: Optional[Iterable[ThingGroupName]] = Optional.Absent,
    attributes: Optional[Map[AttributeName, AttributeValue]] = Optional.Absent,
    shadow: Optional[JsonDocument] = Optional.Absent,
    deviceDefender: Optional[JsonDocument] = Optional.Absent,
    connectivity: Optional[zio.aws.iot.model.ThingConnectivity] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ThingDocument = {
    import ThingDocument.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ThingDocument
      .builder()
      .optionallyWith(
        thingName.map(value => ThingName.unwrap(value): java.lang.String)
      )(_.thingName)
      .optionallyWith(
        thingId.map(value => ThingId.unwrap(value): java.lang.String)
      )(_.thingId)
      .optionallyWith(
        thingTypeName.map(value =>
          ThingTypeName.unwrap(value): java.lang.String
        )
      )(_.thingTypeName)
      .optionallyWith(
        thingGroupNames.map(value =>
          value.map { item =>
            ThingGroupName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.thingGroupNames)
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> (AttributeValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .optionallyWith(
        shadow.map(value => JsonDocument.unwrap(value): java.lang.String)
      )(_.shadow)
      .optionallyWith(
        deviceDefender.map(value =>
          JsonDocument.unwrap(value): java.lang.String
        )
      )(_.deviceDefender)
      .optionallyWith(connectivity.map(value => value.buildAwsValue()))(
        _.connectivity
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ThingDocument.ReadOnly =
    zio.aws.iot.model.ThingDocument.wrap(buildAwsValue())
}
object ThingDocument {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.ThingDocument] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ThingDocument =
      zio.aws.iot.model.ThingDocument(
        thingName.map(value => value),
        thingId.map(value => value),
        thingTypeName.map(value => value),
        thingGroupNames.map(value => value),
        attributes.map(value => value),
        shadow.map(value => value),
        deviceDefender.map(value => value),
        connectivity.map(value => value.asEditable)
      )
    def thingName: Optional[ThingName]
    def thingId: Optional[ThingId]
    def thingTypeName: Optional[ThingTypeName]
    def thingGroupNames: Optional[List[ThingGroupName]]
    def attributes: Optional[Map[AttributeName, AttributeValue]]
    def shadow: Optional[JsonDocument]
    def deviceDefender: Optional[JsonDocument]
    def connectivity: Optional[zio.aws.iot.model.ThingConnectivity.ReadOnly]
    def getThingName: ZIO[Any, AwsError, ThingName] =
      AwsError.unwrapOptionField("thingName", thingName)
    def getThingId: ZIO[Any, AwsError, ThingId] =
      AwsError.unwrapOptionField("thingId", thingId)
    def getThingTypeName: ZIO[Any, AwsError, ThingTypeName] =
      AwsError.unwrapOptionField("thingTypeName", thingTypeName)
    def getThingGroupNames: ZIO[Any, AwsError, List[ThingGroupName]] =
      AwsError.unwrapOptionField("thingGroupNames", thingGroupNames)
    def getAttributes: ZIO[Any, AwsError, Map[AttributeName, AttributeValue]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getShadow: ZIO[Any, AwsError, JsonDocument] =
      AwsError.unwrapOptionField("shadow", shadow)
    def getDeviceDefender: ZIO[Any, AwsError, JsonDocument] =
      AwsError.unwrapOptionField("deviceDefender", deviceDefender)
    def getConnectivity
        : ZIO[Any, AwsError, zio.aws.iot.model.ThingConnectivity.ReadOnly] =
      AwsError.unwrapOptionField("connectivity", connectivity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ThingDocument
  ) extends zio.aws.iot.model.ThingDocument.ReadOnly {
    override val thingName: Optional[ThingName] = zio.aws.core.internal
      .optionalFromNullable(impl.thingName())
      .map(value => zio.aws.iot.model.primitives.ThingName(value))
    override val thingId: Optional[ThingId] = zio.aws.core.internal
      .optionalFromNullable(impl.thingId())
      .map(value => zio.aws.iot.model.primitives.ThingId(value))
    override val thingTypeName: Optional[ThingTypeName] = zio.aws.core.internal
      .optionalFromNullable(impl.thingTypeName())
      .map(value => zio.aws.iot.model.primitives.ThingTypeName(value))
    override val thingGroupNames: Optional[List[ThingGroupName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thingGroupNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.primitives.ThingGroupName(item)
          }.toList
        )
    override val attributes: Optional[Map[AttributeName, AttributeValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.iot.model.primitives.AttributeName(
                key
              ) -> zio.aws.iot.model.primitives.AttributeValue(value)
            })
            .toMap
        )
    override val shadow: Optional[JsonDocument] = zio.aws.core.internal
      .optionalFromNullable(impl.shadow())
      .map(value => zio.aws.iot.model.primitives.JsonDocument(value))
    override val deviceDefender: Optional[JsonDocument] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceDefender())
      .map(value => zio.aws.iot.model.primitives.JsonDocument(value))
    override val connectivity
        : Optional[zio.aws.iot.model.ThingConnectivity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectivity())
        .map(value => zio.aws.iot.model.ThingConnectivity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ThingDocument
  ): zio.aws.iot.model.ThingDocument.ReadOnly = new Wrapper(impl)
}
