package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{CreationDate, DeprecationDate}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ThingTypeMetadata(
    deprecated: Optional[Boolean] = Optional.Absent,
    deprecationDate: Optional[DeprecationDate] = Optional.Absent,
    creationDate: Optional[CreationDate] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ThingTypeMetadata = {
    import ThingTypeMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ThingTypeMetadata
      .builder()
      .optionallyWith(deprecated.map(value => value: java.lang.Boolean))(
        _.deprecated
      )
      .optionallyWith(
        deprecationDate.map(value => DeprecationDate.unwrap(value): Instant)
      )(_.deprecationDate)
      .optionallyWith(
        creationDate.map(value => CreationDate.unwrap(value): Instant)
      )(_.creationDate)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ThingTypeMetadata.ReadOnly =
    zio.aws.iot.model.ThingTypeMetadata.wrap(buildAwsValue())
}
object ThingTypeMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ThingTypeMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ThingTypeMetadata =
      zio.aws.iot.model.ThingTypeMetadata(
        deprecated.map(value => value),
        deprecationDate.map(value => value),
        creationDate.map(value => value)
      )
    def deprecated: Optional[Boolean]
    def deprecationDate: Optional[DeprecationDate]
    def creationDate: Optional[CreationDate]
    def getDeprecated: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deprecated", deprecated)
    def getDeprecationDate: ZIO[Any, AwsError, DeprecationDate] =
      AwsError.unwrapOptionField("deprecationDate", deprecationDate)
    def getCreationDate: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ThingTypeMetadata
  ) extends zio.aws.iot.model.ThingTypeMetadata.ReadOnly {
    override val deprecated: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.deprecated())
      .map(value => value: Boolean)
    override val deprecationDate: Optional[DeprecationDate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deprecationDate())
        .map(value => zio.aws.iot.model.primitives.DeprecationDate(value))
    override val creationDate: Optional[CreationDate] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.CreationDate(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ThingTypeMetadata
  ): zio.aws.iot.model.ThingTypeMetadata.ReadOnly = new Wrapper(impl)
}
