package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  IndexName,
  OptionalVersion,
  QueryVersion,
  QueryString,
  ThingGroupName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateDynamicThingGroupRequest(
    thingGroupName: ThingGroupName,
    thingGroupProperties: zio.aws.iot.model.ThingGroupProperties,
    expectedVersion: Optional[OptionalVersion] = Optional.Absent,
    indexName: Optional[IndexName] = Optional.Absent,
    queryString: Optional[QueryString] = Optional.Absent,
    queryVersion: Optional[QueryVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateDynamicThingGroupRequest = {
    import UpdateDynamicThingGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateDynamicThingGroupRequest
      .builder()
      .thingGroupName(ThingGroupName.unwrap(thingGroupName): java.lang.String)
      .thingGroupProperties(thingGroupProperties.buildAwsValue())
      .optionallyWith(
        expectedVersion.map(value =>
          OptionalVersion.unwrap(value): java.lang.Long
        )
      )(_.expectedVersion)
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .optionallyWith(
        queryString.map(value => QueryString.unwrap(value): java.lang.String)
      )(_.queryString)
      .optionallyWith(
        queryVersion.map(value => QueryVersion.unwrap(value): java.lang.String)
      )(_.queryVersion)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateDynamicThingGroupRequest.ReadOnly =
    zio.aws.iot.model.UpdateDynamicThingGroupRequest.wrap(buildAwsValue())
}
object UpdateDynamicThingGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateDynamicThingGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateDynamicThingGroupRequest =
      zio.aws.iot.model.UpdateDynamicThingGroupRequest(
        thingGroupName,
        thingGroupProperties.asEditable,
        expectedVersion.map(value => value),
        indexName.map(value => value),
        queryString.map(value => value),
        queryVersion.map(value => value)
      )
    def thingGroupName: ThingGroupName
    def thingGroupProperties: zio.aws.iot.model.ThingGroupProperties.ReadOnly
    def expectedVersion: Optional[OptionalVersion]
    def indexName: Optional[IndexName]
    def queryString: Optional[QueryString]
    def queryVersion: Optional[QueryVersion]
    def getThingGroupName: ZIO[Any, Nothing, ThingGroupName] =
      ZIO.succeed(thingGroupName)
    def getThingGroupProperties
        : ZIO[Any, Nothing, zio.aws.iot.model.ThingGroupProperties.ReadOnly] =
      ZIO.succeed(thingGroupProperties)
    def getExpectedVersion: ZIO[Any, AwsError, OptionalVersion] =
      AwsError.unwrapOptionField("expectedVersion", expectedVersion)
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getQueryString: ZIO[Any, AwsError, QueryString] =
      AwsError.unwrapOptionField("queryString", queryString)
    def getQueryVersion: ZIO[Any, AwsError, QueryVersion] =
      AwsError.unwrapOptionField("queryVersion", queryVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateDynamicThingGroupRequest
  ) extends zio.aws.iot.model.UpdateDynamicThingGroupRequest.ReadOnly {
    override val thingGroupName: ThingGroupName =
      zio.aws.iot.model.primitives.ThingGroupName(impl.thingGroupName())
    override val thingGroupProperties
        : zio.aws.iot.model.ThingGroupProperties.ReadOnly =
      zio.aws.iot.model.ThingGroupProperties.wrap(impl.thingGroupProperties())
    override val expectedVersion: Optional[OptionalVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedVersion())
        .map(value => zio.aws.iot.model.primitives.OptionalVersion(value))
    override val indexName: Optional[IndexName] = zio.aws.core.internal
      .optionalFromNullable(impl.indexName())
      .map(value => zio.aws.iot.model.primitives.IndexName(value))
    override val queryString: Optional[QueryString] = zio.aws.core.internal
      .optionalFromNullable(impl.queryString())
      .map(value => zio.aws.iot.model.primitives.QueryString(value))
    override val queryVersion: Optional[QueryVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.queryVersion())
      .map(value => zio.aws.iot.model.primitives.QueryVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateDynamicThingGroupRequest
  ): zio.aws.iot.model.UpdateDynamicThingGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
