package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  IndexName,
  AggregationField,
  FleetMetricPeriod,
  OptionalVersion,
  FleetMetricDescription,
  FleetMetricName,
  QueryVersion,
  QueryString
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class UpdateFleetMetricRequest(
    metricName: FleetMetricName,
    queryString: Optional[QueryString] = Optional.Absent,
    aggregationType: Optional[zio.aws.iot.model.AggregationType] =
      Optional.Absent,
    period: Optional[FleetMetricPeriod] = Optional.Absent,
    aggregationField: Optional[AggregationField] = Optional.Absent,
    description: Optional[FleetMetricDescription] = Optional.Absent,
    queryVersion: Optional[QueryVersion] = Optional.Absent,
    indexName: IndexName,
    unit: Optional[zio.aws.iot.model.FleetMetricUnit] = Optional.Absent,
    expectedVersion: Optional[OptionalVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateFleetMetricRequest = {
    import UpdateFleetMetricRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateFleetMetricRequest
      .builder()
      .metricName(FleetMetricName.unwrap(metricName): java.lang.String)
      .optionallyWith(
        queryString.map(value => QueryString.unwrap(value): java.lang.String)
      )(_.queryString)
      .optionallyWith(aggregationType.map(value => value.buildAwsValue()))(
        _.aggregationType
      )
      .optionallyWith(
        period.map(value => FleetMetricPeriod.unwrap(value): Integer)
      )(_.period)
      .optionallyWith(
        aggregationField.map(value =>
          AggregationField.unwrap(value): java.lang.String
        )
      )(_.aggregationField)
      .optionallyWith(
        description.map(value =>
          FleetMetricDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        queryVersion.map(value => QueryVersion.unwrap(value): java.lang.String)
      )(_.queryVersion)
      .indexName(IndexName.unwrap(indexName): java.lang.String)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .optionallyWith(
        expectedVersion.map(value =>
          OptionalVersion.unwrap(value): java.lang.Long
        )
      )(_.expectedVersion)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateFleetMetricRequest.ReadOnly =
    zio.aws.iot.model.UpdateFleetMetricRequest.wrap(buildAwsValue())
}
object UpdateFleetMetricRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateFleetMetricRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateFleetMetricRequest =
      zio.aws.iot.model.UpdateFleetMetricRequest(
        metricName,
        queryString.map(value => value),
        aggregationType.map(value => value.asEditable),
        period.map(value => value),
        aggregationField.map(value => value),
        description.map(value => value),
        queryVersion.map(value => value),
        indexName,
        unit.map(value => value),
        expectedVersion.map(value => value)
      )
    def metricName: FleetMetricName
    def queryString: Optional[QueryString]
    def aggregationType: Optional[zio.aws.iot.model.AggregationType.ReadOnly]
    def period: Optional[FleetMetricPeriod]
    def aggregationField: Optional[AggregationField]
    def description: Optional[FleetMetricDescription]
    def queryVersion: Optional[QueryVersion]
    def indexName: IndexName
    def unit: Optional[zio.aws.iot.model.FleetMetricUnit]
    def expectedVersion: Optional[OptionalVersion]
    def getMetricName: ZIO[Any, Nothing, FleetMetricName] =
      ZIO.succeed(metricName)
    def getQueryString: ZIO[Any, AwsError, QueryString] =
      AwsError.unwrapOptionField("queryString", queryString)
    def getAggregationType
        : ZIO[Any, AwsError, zio.aws.iot.model.AggregationType.ReadOnly] =
      AwsError.unwrapOptionField("aggregationType", aggregationType)
    def getPeriod: ZIO[Any, AwsError, FleetMetricPeriod] =
      AwsError.unwrapOptionField("period", period)
    def getAggregationField: ZIO[Any, AwsError, AggregationField] =
      AwsError.unwrapOptionField("aggregationField", aggregationField)
    def getDescription: ZIO[Any, AwsError, FleetMetricDescription] =
      AwsError.unwrapOptionField("description", description)
    def getQueryVersion: ZIO[Any, AwsError, QueryVersion] =
      AwsError.unwrapOptionField("queryVersion", queryVersion)
    def getIndexName: ZIO[Any, Nothing, IndexName] = ZIO.succeed(indexName)
    def getUnit: ZIO[Any, AwsError, zio.aws.iot.model.FleetMetricUnit] =
      AwsError.unwrapOptionField("unit", unit)
    def getExpectedVersion: ZIO[Any, AwsError, OptionalVersion] =
      AwsError.unwrapOptionField("expectedVersion", expectedVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateFleetMetricRequest
  ) extends zio.aws.iot.model.UpdateFleetMetricRequest.ReadOnly {
    override val metricName: FleetMetricName =
      zio.aws.iot.model.primitives.FleetMetricName(impl.metricName())
    override val queryString: Optional[QueryString] = zio.aws.core.internal
      .optionalFromNullable(impl.queryString())
      .map(value => zio.aws.iot.model.primitives.QueryString(value))
    override val aggregationType
        : Optional[zio.aws.iot.model.AggregationType.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aggregationType())
        .map(value => zio.aws.iot.model.AggregationType.wrap(value))
    override val period: Optional[FleetMetricPeriod] = zio.aws.core.internal
      .optionalFromNullable(impl.period())
      .map(value => zio.aws.iot.model.primitives.FleetMetricPeriod(value))
    override val aggregationField: Optional[AggregationField] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aggregationField())
        .map(value => zio.aws.iot.model.primitives.AggregationField(value))
    override val description: Optional[FleetMetricDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.iot.model.primitives.FleetMetricDescription(value)
        )
    override val queryVersion: Optional[QueryVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.queryVersion())
      .map(value => zio.aws.iot.model.primitives.QueryVersion(value))
    override val indexName: IndexName =
      zio.aws.iot.model.primitives.IndexName(impl.indexName())
    override val unit: Optional[zio.aws.iot.model.FleetMetricUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unit())
        .map(value => zio.aws.iot.model.FleetMetricUnit.wrap(value))
    override val expectedVersion: Optional[OptionalVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedVersion())
        .map(value => zio.aws.iot.model.primitives.OptionalVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateFleetMetricRequest
  ): zio.aws.iot.model.UpdateFleetMetricRequest.ReadOnly = new Wrapper(impl)
}
