package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  DeleteAdditionalMetricsToRetain,
  OptionalVersion,
  SecurityProfileDescription,
  DeleteAlertTargets,
  DeleteBehaviors,
  SecurityProfileName,
  BehaviorMetric
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateSecurityProfileRequest(
    securityProfileName: SecurityProfileName,
    securityProfileDescription: Optional[SecurityProfileDescription] =
      Optional.Absent,
    behaviors: Optional[Iterable[zio.aws.iot.model.Behavior]] = Optional.Absent,
    alertTargets: Optional[
      Map[zio.aws.iot.model.AlertTargetType, zio.aws.iot.model.AlertTarget]
    ] = Optional.Absent,
    additionalMetricsToRetain: Optional[Iterable[BehaviorMetric]] =
      Optional.Absent,
    additionalMetricsToRetainV2: Optional[
      Iterable[zio.aws.iot.model.MetricToRetain]
    ] = Optional.Absent,
    deleteBehaviors: Optional[DeleteBehaviors] = Optional.Absent,
    deleteAlertTargets: Optional[DeleteAlertTargets] = Optional.Absent,
    deleteAdditionalMetricsToRetain: Optional[DeleteAdditionalMetricsToRetain] =
      Optional.Absent,
    expectedVersion: Optional[OptionalVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateSecurityProfileRequest = {
    import UpdateSecurityProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateSecurityProfileRequest
      .builder()
      .securityProfileName(
        SecurityProfileName.unwrap(securityProfileName): java.lang.String
      )
      .optionallyWith(
        securityProfileDescription.map(value =>
          SecurityProfileDescription.unwrap(value): java.lang.String
        )
      )(_.securityProfileDescription)
      .optionallyWith(
        behaviors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.behaviors)
      .optionallyWith(
        alertTargets.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.alertTargetsWithStrings)
      .optionallyWith(
        additionalMetricsToRetain.map(value =>
          value.map { item =>
            BehaviorMetric.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.additionalMetricsToRetain)
      .optionallyWith(
        additionalMetricsToRetainV2.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.additionalMetricsToRetainV2)
      .optionallyWith(
        deleteBehaviors.map(value =>
          DeleteBehaviors.unwrap(value): java.lang.Boolean
        )
      )(_.deleteBehaviors)
      .optionallyWith(
        deleteAlertTargets.map(value =>
          DeleteAlertTargets.unwrap(value): java.lang.Boolean
        )
      )(_.deleteAlertTargets)
      .optionallyWith(
        deleteAdditionalMetricsToRetain.map(value =>
          DeleteAdditionalMetricsToRetain.unwrap(value): java.lang.Boolean
        )
      )(_.deleteAdditionalMetricsToRetain)
      .optionallyWith(
        expectedVersion.map(value =>
          OptionalVersion.unwrap(value): java.lang.Long
        )
      )(_.expectedVersion)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateSecurityProfileRequest.ReadOnly =
    zio.aws.iot.model.UpdateSecurityProfileRequest.wrap(buildAwsValue())
}
object UpdateSecurityProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateSecurityProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateSecurityProfileRequest =
      zio.aws.iot.model.UpdateSecurityProfileRequest(
        securityProfileName,
        securityProfileDescription.map(value => value),
        behaviors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        alertTargets.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        additionalMetricsToRetain.map(value => value),
        additionalMetricsToRetainV2.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        deleteBehaviors.map(value => value),
        deleteAlertTargets.map(value => value),
        deleteAdditionalMetricsToRetain.map(value => value),
        expectedVersion.map(value => value)
      )
    def securityProfileName: SecurityProfileName
    def securityProfileDescription: Optional[SecurityProfileDescription]
    def behaviors: Optional[List[zio.aws.iot.model.Behavior.ReadOnly]]
    def alertTargets: Optional[Map[
      zio.aws.iot.model.AlertTargetType,
      zio.aws.iot.model.AlertTarget.ReadOnly
    ]]
    def additionalMetricsToRetain: Optional[List[BehaviorMetric]]
    def additionalMetricsToRetainV2
        : Optional[List[zio.aws.iot.model.MetricToRetain.ReadOnly]]
    def deleteBehaviors: Optional[DeleteBehaviors]
    def deleteAlertTargets: Optional[DeleteAlertTargets]
    def deleteAdditionalMetricsToRetain
        : Optional[DeleteAdditionalMetricsToRetain]
    def expectedVersion: Optional[OptionalVersion]
    def getSecurityProfileName: ZIO[Any, Nothing, SecurityProfileName] =
      ZIO.succeed(securityProfileName)
    def getSecurityProfileDescription
        : ZIO[Any, AwsError, SecurityProfileDescription] =
      AwsError.unwrapOptionField(
        "securityProfileDescription",
        securityProfileDescription
      )
    def getBehaviors
        : ZIO[Any, AwsError, List[zio.aws.iot.model.Behavior.ReadOnly]] =
      AwsError.unwrapOptionField("behaviors", behaviors)
    def getAlertTargets: ZIO[Any, AwsError, Map[
      zio.aws.iot.model.AlertTargetType,
      zio.aws.iot.model.AlertTarget.ReadOnly
    ]] = AwsError.unwrapOptionField("alertTargets", alertTargets)
    def getAdditionalMetricsToRetain: ZIO[Any, AwsError, List[BehaviorMetric]] =
      AwsError.unwrapOptionField(
        "additionalMetricsToRetain",
        additionalMetricsToRetain
      )
    def getAdditionalMetricsToRetainV2
        : ZIO[Any, AwsError, List[zio.aws.iot.model.MetricToRetain.ReadOnly]] =
      AwsError.unwrapOptionField(
        "additionalMetricsToRetainV2",
        additionalMetricsToRetainV2
      )
    def getDeleteBehaviors: ZIO[Any, AwsError, DeleteBehaviors] =
      AwsError.unwrapOptionField("deleteBehaviors", deleteBehaviors)
    def getDeleteAlertTargets: ZIO[Any, AwsError, DeleteAlertTargets] =
      AwsError.unwrapOptionField("deleteAlertTargets", deleteAlertTargets)
    def getDeleteAdditionalMetricsToRetain
        : ZIO[Any, AwsError, DeleteAdditionalMetricsToRetain] =
      AwsError.unwrapOptionField(
        "deleteAdditionalMetricsToRetain",
        deleteAdditionalMetricsToRetain
      )
    def getExpectedVersion: ZIO[Any, AwsError, OptionalVersion] =
      AwsError.unwrapOptionField("expectedVersion", expectedVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateSecurityProfileRequest
  ) extends zio.aws.iot.model.UpdateSecurityProfileRequest.ReadOnly {
    override val securityProfileName: SecurityProfileName =
      zio.aws.iot.model.primitives
        .SecurityProfileName(impl.securityProfileName())
    override val securityProfileDescription
        : Optional[SecurityProfileDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.securityProfileDescription())
      .map(value =>
        zio.aws.iot.model.primitives.SecurityProfileDescription(value)
      )
    override val behaviors
        : Optional[List[zio.aws.iot.model.Behavior.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.behaviors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.Behavior.wrap(item)
          }.toList
        )
    override val alertTargets: Optional[Map[
      zio.aws.iot.model.AlertTargetType,
      zio.aws.iot.model.AlertTarget.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.alertTargets())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iot.model.AlertTargetType
              .wrap(key) -> zio.aws.iot.model.AlertTarget.wrap(value)
          })
          .toMap
      )
    override val additionalMetricsToRetain: Optional[List[BehaviorMetric]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalMetricsToRetain())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.primitives.BehaviorMetric(item)
          }.toList
        )
    override val additionalMetricsToRetainV2
        : Optional[List[zio.aws.iot.model.MetricToRetain.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalMetricsToRetainV2())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.MetricToRetain.wrap(item)
          }.toList
        )
    override val deleteBehaviors: Optional[DeleteBehaviors] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deleteBehaviors())
        .map(value => zio.aws.iot.model.primitives.DeleteBehaviors(value))
    override val deleteAlertTargets: Optional[DeleteAlertTargets] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deleteAlertTargets())
        .map(value => zio.aws.iot.model.primitives.DeleteAlertTargets(value))
    override val deleteAdditionalMetricsToRetain
        : Optional[DeleteAdditionalMetricsToRetain] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteAdditionalMetricsToRetain())
      .map(value =>
        zio.aws.iot.model.primitives.DeleteAdditionalMetricsToRetain(value)
      )
    override val expectedVersion: Optional[OptionalVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedVersion())
        .map(value => zio.aws.iot.model.primitives.OptionalVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateSecurityProfileRequest
  ): zio.aws.iot.model.UpdateSecurityProfileRequest.ReadOnly = new Wrapper(impl)
}
